/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.cache;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.GetProviderNameEvent;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.harvest.utils.cache.DocumentChangesCache;
import de.gerdiproject.harvest.utils.cache.DocumentVersionsCache;
import de.gerdiproject.harvest.utils.cache.FileUtils;
import de.gerdiproject.harvest.utils.cache.HarvesterCacheManager;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.io.File;

public class HarvesterCache {
    private final DocumentVersionsCache versionsCache;
    private final DocumentChangesCache changesCache;
    private final String harvesterId;
    private final File harvesterCacheFolder;

    public HarvesterCache(String harvesterName) {
        String providerName = (String)EventSystem.sendSynchronousEvent(new GetProviderNameEvent());
        this.harvesterId = providerName + harvesterName;
        this.harvesterCacheFolder = new File(String.format("cache/%s/documents_temp/%s/latestChanges", MainContext.getModuleName(), harvesterName)).getParentFile();
        this.versionsCache = new DocumentVersionsCache(harvesterName);
        this.changesCache = new DocumentChangesCache(harvesterName);
        EventSystem.addListener(ContextDestroyedEvent.class, this::onContextDestroyed);
        HarvesterCacheManager.instance().registerCache(this);
    }

    public DocumentChangesCache getChangesCache() {
        return this.changesCache;
    }

    public DocumentVersionsCache getVersionsCache() {
        return this.versionsCache;
    }

    public void skipAllDocuments() {
        this.versionsCache.forEach((documentId, documentHash) -> {
            this.changesCache.removeFile((String)documentId);
            return true;
        });
    }

    public void cacheDocument(IDocument doc) {
        if (this.hasDocumentChanged(doc)) {
            this.addDocument(doc);
        } else {
            this.skipDocument(doc);
        }
    }

    public void addDocument(IDocument doc) {
        String documentId = this.getDocumentId(doc);
        if (doc instanceof DataCiteJson) {
            this.changesCache.putFile(documentId, (DataCiteJson)doc);
        }
        this.versionsCache.putFile(documentId, HashGenerator.instance().getShaHash(doc));
    }

    public void applyChanges(boolean isSuccessful, boolean isAborted) {
        this.changesCache.applyChanges();
        if (isSuccessful && !isAborted) {
            this.changesCache.forEach((documentId, document) -> {
                if (document == null) {
                    this.versionsCache.removeFile((String)documentId);
                }
                return true;
            });
        }
        this.versionsCache.applyChanges();
    }

    public void init(String hash, int harvestStartIndex, int harvestEndIndex) {
        String harvesterHash = hash == null ? null : HashGenerator.instance().getShaHash(hash + harvestStartIndex + harvestEndIndex);
        this.versionsCache.init(harvesterHash);
        this.changesCache.init(this.versionsCache);
    }

    private void skipDocument(IDocument doc) {
        String documentId = this.getDocumentId(doc);
        this.changesCache.removeFile(documentId);
    }

    private String getDocumentId(IDocument doc) {
        return HashGenerator.instance().getShaHash(this.harvesterId + doc.getSourceId());
    }

    private boolean hasDocumentChanged(IDocument doc) {
        String documentId = this.getDocumentId(doc);
        String oldHash = (String)this.versionsCache.getFileContent(documentId);
        if (oldHash == null) {
            return true;
        }
        String currentHash = HashGenerator.instance().getShaHash(doc);
        return !oldHash.equals(currentHash);
    }

    private void onContextDestroyed(ContextDestroyedEvent event) {
        FileUtils.deleteFile(this.harvesterCacheFolder);
    }
}

