/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.cache;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static void deleteFile(File deletedFile) {
        if (deletedFile.exists()) {
            boolean wasDeleted;
            IOException ioException = null;
            if (deletedFile.isDirectory()) {
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(deletedFile.toPath());){
                    for (Path fileInDir : dirStream) {
                        FileUtils.deleteFile(fileInDir.toFile());
                    }
                }
                catch (IOException e) {
                    wasDeleted = false;
                    ioException = e;
                }
            }
            if (!(wasDeleted = deletedFile.delete())) {
                if (ioException != null) {
                    LOGGER.error(String.format("Could not delete file '%s'!", deletedFile.getPath()), (Throwable)ioException);
                } else {
                    LOGGER.error(String.format("Could not delete file '%s'!", deletedFile.getPath()));
                }
            } else {
                LOGGER.trace(String.format("Deleted file '%s'.", deletedFile.getPath()));
            }
        }
    }

    public static void replaceFile(File targetFile, File newFile) {
        FileUtils.deleteFile(targetFile);
        if (!FileUtils.createDirectories(targetFile.getParentFile())) {
            LOGGER.error(String.format("Could not replace file '%s' with '%s': The target directory does not exist and could not be created!", targetFile.getAbsolutePath(), newFile.getAbsolutePath()));
            return;
        }
        if (!newFile.renameTo(targetFile)) {
            LOGGER.error(String.format("Could not replace file '%s' with '%s'!", targetFile.getPath(), newFile.getPath()));
        } else {
            LOGGER.trace(String.format("Replaced file '%s' with '%s'.", targetFile.getPath(), newFile.getPath()));
        }
    }

    public static void copyFile(File sourceFile, File targetFile) {
        if (FileUtils.createDirectories(sourceFile.isDirectory() ? targetFile : targetFile.getParentFile())) {
            try {
                Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error(String.format("Could not copy file '%s' to '%s'!", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath()));
                return;
            }
            LOGGER.trace(String.format("Copied file '%s' to '%s'.", sourceFile.getPath(), targetFile.getPath()));
        }
    }

    public static boolean createDirectories(File directory) {
        if (directory == null || directory.exists()) {
            return true;
        }
        boolean creationSuccessful = directory.mkdirs();
        if (creationSuccessful) {
            LOGGER.trace(String.format("Created directory '%s'.", directory.getPath()));
        } else {
            LOGGER.error(String.format("Could not create directory '%s'!", directory.getPath()));
        }
        return creationSuccessful;
    }

    public static void createEmptyFile(File file) {
        FileUtils.deleteFile(file);
        boolean creationSuccessful = FileUtils.createDirectories(file.getParentFile());
        IOException ioException = null;
        try {
            creationSuccessful &= file.createNewFile();
        }
        catch (IOException e) {
            creationSuccessful = false;
            ioException = e;
        }
        if (!creationSuccessful) {
            if (ioException != null) {
                LOGGER.error(String.format("Could not create file '%s'!", file.getPath()), (Throwable)ioException);
            } else {
                LOGGER.error(String.format("Could not create file '%s'!", file.getPath()));
            }
        } else {
            LOGGER.trace(String.format("Created file '%s'.", file.getPath()));
        }
    }

    public static void integrateDirectory(File sourceDirectory, File targetDirectory, boolean replaceFiles) {
        if (!FileUtils.createDirectories(targetDirectory)) {
            LOGGER.error(String.format("Could not merge '%s' into '%s': The target directory does not exist and could not be created!", sourceDirectory.getPath(), targetDirectory.getPath()));
            return;
        }
        if (!sourceDirectory.isDirectory() || !targetDirectory.isDirectory()) {
            LOGGER.error(String.format("Could not merge '%s' into '%s': Both paths must denote directories!", sourceDirectory.getPath(), targetDirectory.getPath()));
            return;
        }
        try (DirectoryStream<Path> sourceStream = Files.newDirectoryStream(sourceDirectory.toPath());){
            for (Path sourceFilePath : sourceStream) {
                File sourceFile = sourceFilePath.toFile();
                File targetFile = new File(targetDirectory, sourceFile.getName());
                if (sourceFile.isDirectory()) {
                    FileUtils.integrateDirectory(sourceFile, targetFile, replaceFiles);
                    continue;
                }
                if (replaceFiles) {
                    FileUtils.deleteFile(targetFile);
                }
                if (targetFile.exists()) continue;
                FileUtils.copyFile(sourceFile, targetFile);
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not merge '%s' into '%s'!", sourceDirectory.getPath(), targetDirectory.getPath()), (Throwable)e);
            return;
        }
        LOGGER.trace(String.format("Merged folder '%s' into '%s'.", sourceDirectory.getPath(), targetDirectory.getPath()));
        FileUtils.deleteFile(sourceDirectory);
    }
}

