/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.cache;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.utils.cache.AbstractCache;
import de.gerdiproject.harvest.utils.cache.DocumentVersionsCache;
import de.gerdiproject.harvest.utils.cache.FileUtils;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicInteger;

public class DocumentChangesCache
extends AbstractCache<DataCiteJson> {
    private int size;

    public DocumentChangesCache(String harvesterName) {
        super(String.format("cache/%s/documents/%s/latestChanges", MainContext.getModuleName(), harvesterName), String.format("cache/%s/documents_temp/%s/latestChanges", MainContext.getModuleName(), harvesterName), DataCiteJson.class);
    }

    public void init(DocumentVersionsCache versionsCache) {
        AtomicInteger numberOfCopiedIds = new AtomicInteger(0);
        boolean isSuccessful = false;
        isSuccessful = versionsCache.forEach((documentId, documentHash) -> {
            FileUtils.createEmptyFile(this.getFile((String)documentId, false));
            numberOfCopiedIds.incrementAndGet();
            return true;
        });
        this.size = isSuccessful ? numberOfCopiedIds.get() : 0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void applyChanges() {
        FileUtils.replaceFile(new File(this.stableFolderPath), new File(this.wipFolderPath));
    }

    @Override
    public void putFile(String documentId, DataCiteJson document) {
        File documentFile = this.getFile(documentId, false);
        if (documentFile.exists() && document == null) {
            --this.size;
        } else if (!documentFile.exists() && document != null) {
            ++this.size;
        }
        super.putFile(documentId, document);
    }

    @Override
    @Deprecated
    protected void migrateToNewSystem() {
        String harvesterName = new File(this.stableFolderPath).getParentFile().getName();
        File stableFile = new File(String.format("cache/%s/%s_updatedDocuments.json.json", MainContext.getModuleName(), harvesterName));
        if (stableFile.exists()) {
            Gson gson = GsonUtils.getGson();
            try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(stableFile), MainContext.getCharset()));){
                reader.beginObject();
                while (reader.hasNext()) {
                    String documentId = reader.nextName();
                    File file = this.getFile(documentId, true);
                    if (reader.peek() == JsonToken.NULL) {
                        FileUtils.createEmptyFile(file);
                        reader.skipValue();
                        continue;
                    }
                    this.diskIo.writeObjectToFile(file, gson.fromJson(reader, DataCiteJson.class));
                }
            }
            catch (IOException e) {
                return;
            }
            FileUtils.deleteFile(stableFile);
        }
    }
}

