/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.cache;

import de.gerdiproject.harvest.utils.cache.FileUtils;
import de.gerdiproject.harvest.utils.data.DiskIO;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.BiFunction;

public abstract class AbstractCache<T> {
    private final Class<T> fileContentClass;
    protected final DiskIO diskIo;
    protected final String stableFolderPath;
    protected final String wipFolderPath;

    public AbstractCache(String stableFolderPath, String wipFolderPath, Class<T> fileContentClass) {
        this.stableFolderPath = stableFolderPath;
        this.wipFolderPath = wipFolderPath;
        this.fileContentClass = fileContentClass;
        this.diskIo = new DiskIO();
        this.migrateToNewSystem();
    }

    @Deprecated
    protected abstract void migrateToNewSystem();

    public abstract void applyChanges();

    public boolean forEach(BiFunction<String, T, Boolean> documentFunction) {
        boolean isSuccessful = true;
        File stableDir = new File(this.stableFolderPath);
        if (stableDir.exists()) {
            try (DirectoryStream<Path> prefixStream = Files.newDirectoryStream(stableDir.toPath());){
                for (Path prefixFolderPath : prefixStream) {
                    File prefixFolder = prefixFolderPath.toFile();
                    if (!prefixFolder.isDirectory()) continue;
                    String documentIdPrefix = prefixFolder.getName();
                    try (DirectoryStream<Path> suffixStream = Files.newDirectoryStream(prefixFolderPath);){
                        for (Path suffixFile : suffixStream) {
                            Path fileNamePath = suffixFile.getFileName();
                            if (fileNamePath == null) continue;
                            String documentIdSuffix = fileNamePath.toString();
                            documentIdSuffix = documentIdSuffix.substring(0, documentIdSuffix.lastIndexOf(46));
                            String documentId = documentIdPrefix + documentIdSuffix;
                            isSuccessful = documentFunction.apply(documentId, (String)this.getFileContent(documentId));
                            if (isSuccessful) continue;
                            break;
                        }
                    }
                    if (isSuccessful) continue;
                    break;
                }
            }
            catch (IOException e) {
                isSuccessful = false;
            }
        }
        return isSuccessful;
    }

    public void removeFile(String documentId) {
        this.putFile(documentId, null);
    }

    public void putFile(String documentId, T document) {
        File documentFile = this.getFile(documentId, false);
        if (documentFile.exists()) {
            FileUtils.deleteFile(documentFile);
        }
        if (document != null) {
            this.diskIo.writeObjectToFile(documentFile, document);
        }
    }

    public T getFileContent(String documentId) {
        File retrievedDoc = this.getFile(documentId, true);
        if (retrievedDoc.exists() && retrievedDoc.length() > 0L) {
            return this.diskIo.getObject(retrievedDoc, this.fileContentClass);
        }
        return null;
    }

    protected File getFile(String documentId, boolean isStable) {
        return new File(String.format("%s/%s/%s.json", isStable ? this.stableFolderPath : this.wipFolderPath, documentId.substring(0, 2), documentId.substring(2)));
    }
}

