/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.json.GsonUtils;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashGenerator {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private MessageDigest messageDigest;
    private Charset charset;
    private static final HashGenerator instance = new HashGenerator();

    public static void init(Charset charset) {
        MessageDigest temp;
        HashGenerator.instance.charset = charset;
        try {
            temp = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            temp = null;
        }
        HashGenerator.instance.messageDigest = temp;
    }

    public static HashGenerator instance() {
        return instance;
    }

    public String getShaHash(IDocument doc) {
        return this.getShaHash(GsonUtils.getGson().toJson((Object)doc, doc.getClass()));
    }

    public String getShaHash(String input) {
        byte[] digest = this.messageDigest.digest(input.getBytes(this.charset));
        char[] hexChars = new char[digest.length * 2];
        for (int i = 0; i < digest.length; ++i) {
            int b = 0xFF & digest[i];
            hexChars[i * 2] = HEX_ARRAY[b >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[b & 0xF];
        }
        return new String(hexChars);
    }
}

