/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.save.events.DocumentSavedEvent;
import de.gerdiproject.harvest.save.events.SaveFinishedEvent;
import de.gerdiproject.harvest.state.AbstractProgressingState;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.state.impl.IdleState;
import de.gerdiproject.harvest.submission.events.StartSubmissionEvent;
import de.gerdiproject.harvest.submission.events.SubmissionStartedEvent;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.time.HarvestTimeKeeper;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;

public class SavingState
extends AbstractProgressingState {
    private final Consumer<DocumentSavedEvent> onDocumentSaved = e -> this.addProgress(1);
    private final Consumer<SaveFinishedEvent> onSaveFinished = e -> {
        if (isAutoTriggered && MainContext.getConfiguration().getParameterValue("autoSubmit", Boolean.class).booleanValue()) {
            EventSystem.sendEvent(new StartSubmissionEvent());
        } else {
            StateMachine.setState(new IdleState());
        }
    };

    public SavingState(int numberOfDocsToBeSaved, boolean isAutoTriggered) {
        super(numberOfDocsToBeSaved);
    }

    @Override
    public void onStateEnter() {
        super.onStateEnter();
        EventSystem.addListener(DocumentSavedEvent.class, this.onDocumentSaved);
        EventSystem.addListener(SaveFinishedEvent.class, this.onSaveFinished);
        EventSystem.addListener(SubmissionStartedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_STARTED);
    }

    @Override
    public void onStateLeave() {
        super.onStateLeave();
        EventSystem.removeListener(DocumentSavedEvent.class, this.onDocumentSaved);
        EventSystem.removeListener(SaveFinishedEvent.class, this.onSaveFinished);
        EventSystem.removeListener(SubmissionStartedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_STARTED);
    }

    @Override
    public String getStatusString() {
        HarvestTimeKeeper timeKeeper = MainContext.getTimeKeeper();
        return String.format("Harvest:     %s%nStorage:     %s%nSubmission:  %s", timeKeeper.getHarvestMeasure().toString(), super.getStatusString(), timeKeeper.getSubmissionMeasure().toString());
    }

    @Override
    public Response startHarvest() {
        return ServerResponseFactory.createBusyResponse("Cannot start harvest: Please wait for the search index to be saved to disk!", this.estimateRemainingSeconds());
    }

    @Override
    public Response submit() {
        return ServerResponseFactory.createBusyResponse("Cannot submit documents: Please wait for the search index to be saved to disk!", this.estimateRemainingSeconds());
    }

    @Override
    public Response save() {
        return ServerResponseFactory.createBusyResponse("Cannot save documents: Please wait for the search index to be saved to disk!", this.estimateRemainingSeconds());
    }

    @Override
    public Response isOutdated() {
        return ServerResponseFactory.createBusyResponse("Cannot process request: Please wait for the search index to be saved to disk!", this.estimateRemainingSeconds());
    }

    @Override
    public String getName() {
        return "saving";
    }
}

