/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.application.events.ContextResetEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.HarvesterInitializedEvent;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import javax.ws.rs.core.Response;

public class InitializationState
implements IState {
    @Override
    public void onStateEnter() {
        EventSystem.addListener(HarvesterInitializedEvent.class, StateEventHandlerConstants.ON_HARVESTER_INITIALIZED);
    }

    @Override
    public void onStateLeave() {
        EventSystem.removeListener(HarvesterInitializedEvent.class, StateEventHandlerConstants.ON_HARVESTER_INITIALIZED);
    }

    @Override
    public String getStatusString() {
        return "Initializing harvester...";
    }

    @Override
    public Response startHarvest() {
        return ServerResponseFactory.createInitResponse();
    }

    @Override
    public Response abort() {
        return ServerResponseFactory.createInitResponse();
    }

    @Override
    public Response submit() {
        return ServerResponseFactory.createInitResponse();
    }

    @Override
    public Response save() {
        return ServerResponseFactory.createInitResponse();
    }

    @Override
    public Response getProgress() {
        return ServerResponseFactory.createBadRequestResponse();
    }

    @Override
    public String getName() {
        return "initialization";
    }

    @Override
    public Response reset() {
        EventSystem.sendEvent(new ContextResetEvent());
        return ServerResponseFactory.createAcceptedResponse("Resetting the Harvester Service! This may cause stability issues, because the service is neither in the idling- nor the error state!");
    }

    @Override
    public Response isOutdated() {
        return ServerResponseFactory.createInitResponse();
    }
}

