/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.application.events.ContextResetEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.GetHarvesterOutdatedEvent;
import de.gerdiproject.harvest.harvester.events.HarvestStartedEvent;
import de.gerdiproject.harvest.harvester.events.StartHarvestEvent;
import de.gerdiproject.harvest.save.events.SaveStartedEvent;
import de.gerdiproject.harvest.save.events.StartSaveEvent;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.submission.events.StartSubmissionEvent;
import de.gerdiproject.harvest.submission.events.SubmissionStartedEvent;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.time.HarvestTimeKeeper;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleState
implements IState {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachine.class);

    @Override
    public void onStateEnter() {
        EventSystem.addListener(HarvestStartedEvent.class, StateEventHandlerConstants.ON_HARVEST_STARTED);
        EventSystem.addListener(SubmissionStartedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_STARTED);
        EventSystem.addListener(SaveStartedEvent.class, StateEventHandlerConstants.ON_SAVE_STARTED);
        LOGGER.info(String.format("%s is now ready!", MainContext.getModuleName()));
    }

    @Override
    public void onStateLeave() {
        EventSystem.removeListener(HarvestStartedEvent.class, StateEventHandlerConstants.ON_HARVEST_STARTED);
        EventSystem.removeListener(SubmissionStartedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_STARTED);
        EventSystem.removeListener(SaveStartedEvent.class, StateEventHandlerConstants.ON_SAVE_STARTED);
    }

    @Override
    public String getStatusString() {
        HarvestTimeKeeper timeKeeper = MainContext.getTimeKeeper();
        return String.format("Harvest:     %s%nStorage:     %s%nSubmission:  %s", timeKeeper.getHarvestMeasure().toString(), timeKeeper.getSaveMeasure().toString(), timeKeeper.getSubmissionMeasure().toString());
    }

    @Override
    public Response startHarvest() {
        EventSystem.sendEvent(new StartHarvestEvent());
        return ServerResponseFactory.createAcceptedResponse("Harvest started!");
    }

    @Override
    public Response abort() {
        String message = String.format("Cannot abort %s: No harvest is running!", "harvesting");
        return ServerResponseFactory.createBadRequestResponse(message);
    }

    @Override
    public Response submit() {
        EventSystem.sendEvent(new StartSubmissionEvent());
        return ServerResponseFactory.createAcceptedResponse("Submitting documents...");
    }

    @Override
    public Response save() {
        EventSystem.sendEvent(new StartSaveEvent(false));
        return ServerResponseFactory.createAcceptedResponse("Saving documents to disk...");
    }

    @Override
    public Response reset() {
        EventSystem.sendEvent(new ContextResetEvent());
        return ServerResponseFactory.createAcceptedResponse("Resetting the Harvester Service!");
    }

    @Override
    public Response getProgress() {
        return ServerResponseFactory.createBadRequestResponse();
    }

    @Override
    public String getName() {
        return "idling";
    }

    @Override
    public Response isOutdated() {
        return ServerResponseFactory.createSynchronousEventResponse(new GetHarvesterOutdatedEvent());
    }
}

