/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.DocumentsHarvestedEvent;
import de.gerdiproject.harvest.harvester.events.HarvestFinishedEvent;
import de.gerdiproject.harvest.save.events.SaveStartedEvent;
import de.gerdiproject.harvest.state.AbstractProgressingState;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.submission.events.SubmissionStartedEvent;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.time.HarvestTimeKeeper;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;

public class HarvestingState
extends AbstractProgressingState {
    private final Consumer<DocumentsHarvestedEvent> onDocumentHarvested = e -> this.addProgress(e.getDocumentCount());

    public HarvestingState(int maxNumberOfHarvestedDocuments) {
        super(maxNumberOfHarvestedDocuments);
    }

    @Override
    public void onStateEnter() {
        super.onStateEnter();
        EventSystem.addListener(HarvestFinishedEvent.class, StateEventHandlerConstants.ON_HARVEST_FINISHED);
        EventSystem.addListener(SubmissionStartedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_STARTED);
        EventSystem.addListener(SaveStartedEvent.class, StateEventHandlerConstants.ON_SAVE_STARTED);
        EventSystem.addListener(DocumentsHarvestedEvent.class, this.onDocumentHarvested);
    }

    @Override
    public void onStateLeave() {
        super.onStateLeave();
        EventSystem.removeListener(HarvestFinishedEvent.class, StateEventHandlerConstants.ON_HARVEST_FINISHED);
        EventSystem.removeListener(SubmissionStartedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_STARTED);
        EventSystem.removeListener(SaveStartedEvent.class, StateEventHandlerConstants.ON_SAVE_STARTED);
        EventSystem.removeListener(DocumentsHarvestedEvent.class, this.onDocumentHarvested);
    }

    @Override
    public String getStatusString() {
        HarvestTimeKeeper timeKeeper = MainContext.getTimeKeeper();
        return String.format("Harvest:     %s%nStorage:     %s%nSubmission:  %s", super.getStatusString(), timeKeeper.getSaveMeasure().toString(), timeKeeper.getSubmissionMeasure().toString());
    }

    @Override
    public Response startHarvest() {
        return ServerResponseFactory.createBusyResponse("Cannot start harvest: Please wait for the harvest to finish!", this.estimateRemainingSeconds());
    }

    @Override
    public Response submit() {
        return ServerResponseFactory.createBusyResponse("Cannot submit documents: Please wait for the harvest to finish!", this.estimateRemainingSeconds());
    }

    @Override
    public Response save() {
        return ServerResponseFactory.createBusyResponse("Cannot save documents: Please wait for the harvest to finish!", this.estimateRemainingSeconds());
    }

    @Override
    public Response isOutdated() {
        return ServerResponseFactory.createBusyResponse("Cannot process request: Please wait for the harvest to finish!", this.estimateRemainingSeconds());
    }

    @Override
    public String getName() {
        return "harvesting";
    }
}

