/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.application.events.ContextResetEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.HarvesterInitializedEvent;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import javax.ws.rs.core.Response;

public class ErrorState
implements IState {
    @Override
    public String getStatusString() {
        return "Harvester could not be initialized! Look at the logs for details.";
    }

    @Override
    public void onStateEnter() {
        EventSystem.addListener(HarvesterInitializedEvent.class, StateEventHandlerConstants.ON_HARVESTER_INITIALIZED);
    }

    @Override
    public void onStateLeave() {
        EventSystem.removeListener(HarvesterInitializedEvent.class, StateEventHandlerConstants.ON_HARVESTER_INITIALIZED);
    }

    @Override
    public Response startHarvest() {
        return ServerResponseFactory.createFubarResponse();
    }

    @Override
    public Response abort() {
        return ServerResponseFactory.createFubarResponse();
    }

    @Override
    public Response submit() {
        return ServerResponseFactory.createFubarResponse();
    }

    @Override
    public Response save() {
        return ServerResponseFactory.createFubarResponse();
    }

    @Override
    public Response reset() {
        EventSystem.sendEvent(new ContextResetEvent());
        return ServerResponseFactory.createAcceptedResponse("Resetting the Harvester Service!");
    }

    @Override
    public Response getProgress() {
        return ServerResponseFactory.createFubarResponse();
    }

    @Override
    public String getName() {
        return "error";
    }

    @Override
    public Response isOutdated() {
        return ServerResponseFactory.createFubarResponse();
    }
}

