/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.application.events.ContextResetEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.state.events.AbortingFinishedEvent;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortingState
implements IState {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachine.class);
    private final String processName;

    public AbortingState(String processName) {
        this.processName = processName;
    }

    @Override
    public void onStateEnter() {
        EventSystem.addListener(AbortingFinishedEvent.class, StateEventHandlerConstants.ON_ABORTING_FINISHED);
        LOGGER.info(String.format("Aborting %s-process...", this.processName));
    }

    @Override
    public void onStateLeave() {
        EventSystem.removeListener(AbortingFinishedEvent.class, StateEventHandlerConstants.ON_ABORTING_FINISHED);
        LOGGER.info(String.format("%s-process aborted!", this.processName));
    }

    @Override
    public String getStatusString() {
        return String.format("Aborting %s-process...", this.processName);
    }

    @Override
    public Response startHarvest() {
        return this.createServiceUnavailableResponse();
    }

    @Override
    public Response abort() {
        return this.createServiceUnavailableResponse();
    }

    @Override
    public Response submit() {
        return this.createServiceUnavailableResponse();
    }

    @Override
    public Response save() {
        return this.createServiceUnavailableResponse();
    }

    @Override
    public Response reset() {
        EventSystem.sendEvent(new ContextResetEvent());
        return ServerResponseFactory.createAcceptedResponse("Resetting the Harvester Service! This may cause stability issues, because the service is neither in the idling- nor the error state!");
    }

    @Override
    public Response getProgress() {
        return ServerResponseFactory.createBadRequestResponse();
    }

    @Override
    public String getName() {
        return "aborting";
    }

    @Override
    public Response isOutdated() {
        return this.createServiceUnavailableResponse();
    }

    private Response createServiceUnavailableResponse() {
        return ServerResponseFactory.createBusyResponse(String.format("Cannot process request, because the %s-process is being aborted! Try again in a short moment.", this.processName), -1L);
    }
}

