/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.constants;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.HarvestFinishedEvent;
import de.gerdiproject.harvest.harvester.events.HarvestStartedEvent;
import de.gerdiproject.harvest.harvester.events.HarvesterInitializedEvent;
import de.gerdiproject.harvest.save.events.SaveStartedEvent;
import de.gerdiproject.harvest.save.events.StartSaveEvent;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.events.AbortingFinishedEvent;
import de.gerdiproject.harvest.state.impl.ErrorState;
import de.gerdiproject.harvest.state.impl.HarvestingState;
import de.gerdiproject.harvest.state.impl.IdleState;
import de.gerdiproject.harvest.state.impl.SavingState;
import de.gerdiproject.harvest.state.impl.SubmittingState;
import de.gerdiproject.harvest.submission.events.StartSubmissionEvent;
import de.gerdiproject.harvest.submission.events.SubmissionFinishedEvent;
import de.gerdiproject.harvest.submission.events.SubmissionStartedEvent;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateEventHandlerConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachine.class);
    public static final Consumer<HarvestStartedEvent> ON_HARVEST_STARTED = e -> {
        HarvestingState nextState = new HarvestingState(e.getEndIndex() - e.getStartIndex());
        StateMachine.setState(nextState);
    };
    public static final Consumer<HarvestFinishedEvent> ON_HARVEST_FINISHED = e -> {
        if (e.isSuccessful()) {
            LOGGER.info("Harvest finished!");
            Configuration config = MainContext.getConfiguration();
            if (config.getParameterValue("autoSave", Boolean.class).booleanValue()) {
                EventSystem.sendEvent(new StartSaveEvent(true));
                return;
            }
            if (config.getParameterValue("autoSubmit", Boolean.class).booleanValue()) {
                EventSystem.sendEvent(new StartSubmissionEvent());
                return;
            }
        } else {
            LOGGER.info("Harvest failed!");
        }
        StateMachine.setState(new IdleState());
    };
    public static final Consumer<SubmissionStartedEvent> ON_SUBMISSION_STARTED = e -> {
        SubmittingState nextState = new SubmittingState(e.getNumberOfDocuments());
        StateMachine.setState(nextState);
    };
    public static final Consumer<SaveStartedEvent> ON_SAVE_STARTED = e -> {
        SavingState nextState = new SavingState(e.getNumberOfDocuments(), e.isAutoTriggered());
        StateMachine.setState(nextState);
    };
    public static final Consumer<AbortingFinishedEvent> ON_ABORTING_FINISHED = e -> {
        IdleState nextState = new IdleState();
        StateMachine.setState(nextState);
    };
    public static final Consumer<HarvesterInitializedEvent> ON_HARVESTER_INITIALIZED = e -> {
        if (e.isSuccessful()) {
            StateMachine.setState(new IdleState());
        } else {
            StateMachine.setState(new ErrorState());
        }
    };
    public static final Consumer<SubmissionFinishedEvent> ON_SUBMISSION_FINISHED = e -> StateMachine.setState(new IdleState());

    private StateEventHandlerConstants() {
    }
}

