/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state;

import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.events.AbortingStartedEvent;
import de.gerdiproject.harvest.state.events.StartAbortingEvent;
import de.gerdiproject.harvest.state.impl.AbortingState;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProgressingState
implements IState {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StateMachine.class);
    private final boolean isMaxNumberKnown;
    protected final int maxProgress;
    protected int currentProgress;
    protected long startTimeStamp;
    private final Consumer<AbortingStartedEvent> onAbortingStarted = e -> StateMachine.setState(new AbortingState(this.getName()));

    public AbstractProgressingState(int maxProgress) {
        this.maxProgress = maxProgress;
        this.isMaxNumberKnown = maxProgress > 0 && maxProgress != Integer.MAX_VALUE;
    }

    @Override
    public void onStateEnter() {
        this.startTimeStamp = System.currentTimeMillis();
        EventSystem.addListener(AbortingStartedEvent.class, this.onAbortingStarted);
    }

    @Override
    public void onStateLeave() {
        EventSystem.removeListener(AbortingStartedEvent.class, this.onAbortingStarted);
    }

    @Override
    public String getStatusString() {
        String status = this.isMaxNumberKnown ? String.format("%d / %d (%.2f%%)  Remaining Time: %s", this.currentProgress, this.maxProgress, Float.valueOf(this.getProgressInPercent()), this.getDurationText(this.estimateRemainingSeconds())) : String.format("%d documents", this.currentProgress);
        return status;
    }

    @Override
    public Response getProgress() {
        String entity = this.isMaxNumberKnown ? String.format("%d/%d", this.currentProgress, this.maxProgress) : String.valueOf(this.currentProgress);
        return ServerResponseFactory.createOkResponse(entity);
    }

    @Override
    public Response abort() {
        EventSystem.sendEvent(new StartAbortingEvent());
        return ServerResponseFactory.createAcceptedResponse(String.format("Aborting %s-process...", this.getName()));
    }

    @Override
    public Response reset() {
        return ServerResponseFactory.createBusyResponse(String.format("Cannot reset the service! Please, abort the %s-process first!", this.getName()), this.estimateRemainingSeconds());
    }

    protected long estimateRemainingSeconds() {
        if (this.currentProgress > 0) {
            long milliSecondsUntilNow = System.currentTimeMillis() - this.startTimeStamp;
            long milliSecondsTotal = milliSecondsUntilNow * (long)this.maxProgress / (long)this.currentProgress;
            return (milliSecondsTotal - milliSecondsUntilNow) / 1000L;
        }
        return -1L;
    }

    private float getProgressInPercent() {
        return Math.min(100.0f, 100.0f * (float)this.currentProgress / (float)this.maxProgress);
    }

    private String getDurationText(long durationInSeconds) {
        String durationText;
        if (durationInSeconds < 0L || durationInSeconds == Long.MAX_VALUE) {
            durationText = "unknown";
        } else if (durationInSeconds <= 60L) {
            durationText = String.format("%ds", durationInSeconds);
        } else if (durationInSeconds <= 3600L) {
            long minutes = durationInSeconds / 60L;
            long seconds = durationInSeconds - minutes * 60L;
            durationText = String.format("%dm %ds", minutes, seconds);
        } else if (durationInSeconds <= 86400L) {
            long hours = durationInSeconds / 3600L;
            long minutes = durationInSeconds / 60L - hours * 60L;
            durationText = String.format("%dh %dm", hours, minutes);
        } else {
            long days = durationInSeconds / 86400L;
            long hours = durationInSeconds / 3600L - days * 24L;
            durationText = String.format("%dd %dh", days, hours);
        }
        return durationText;
    }

    public void addProgress(int progress) {
        int oldProgressInPercent = (int)this.getProgressInPercent();
        this.currentProgress += progress;
        int newProgressInPercent = (int)this.getProgressInPercent();
        if (this.isMaxNumberKnown && newProgressInPercent > oldProgressInPercent) {
            LOGGER.info(String.format("%s: %3d%% (%d / %d)", this.getName(), newProgressInPercent, this.currentProgress, this.maxProgress));
        }
    }
}

