/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.scheduler.HarvestingTimerTask;
import de.gerdiproject.harvest.scheduler.events.AddSchedulerTaskEvent;
import de.gerdiproject.harvest.scheduler.events.DeleteSchedulerTaskEvent;
import de.gerdiproject.harvest.scheduler.events.GetScheduleEvent;
import de.gerdiproject.harvest.scheduler.events.ScheduledTaskExecutedEvent;
import de.gerdiproject.harvest.scheduler.utils.CronUtils;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.data.DiskIO;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private Timer timer = new Timer();
    private final Map<String, TimerTask> registeredTasks = new ConcurrentHashMap<String, TimerTask>();

    public void init() {
        EventSystem.addSynchronousListener(AddSchedulerTaskEvent.class, this::onAddTask);
        EventSystem.addSynchronousListener(DeleteSchedulerTaskEvent.class, this::onDeleteSchedule);
        EventSystem.addSynchronousListener(GetScheduleEvent.class, this::onGetSchedule);
        EventSystem.addListener(ScheduledTaskExecutedEvent.class, this::onTaskExecuted);
        EventSystem.addListener(ContextDestroyedEvent.class, this::onContextDestroyed);
        this.loadFromDisk();
    }

    private void loadFromDisk() {
        DiskIO diskReader = new DiskIO();
        String[] cachedCronTabs = diskReader.getObject(String.format("cache/%s/schedule.json", MainContext.getModuleName()), String[].class);
        if (cachedCronTabs != null) {
            for (String cronTab : cachedCronTabs) {
                try {
                    this.scheduleTask(cronTab);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Cannot load cron tab from disk: %s", cronTab), (Throwable)e);
                }
            }
            LOGGER.info("Successfully loaded schedule from disk!");
        }
    }

    private void saveToDisk() {
        DiskIO diskWriter = new DiskIO();
        diskWriter.writeObjectToFile(String.format("cache/%s/schedule.json", MainContext.getModuleName()), this.registeredTasks.keySet());
    }

    private void scheduleTask(String cronTab) throws IllegalArgumentException {
        TimerTask oldTask = this.registeredTasks.get(cronTab);
        if (oldTask != null) {
            oldTask.cancel();
        }
        Date nextDate = CronUtils.getNextMatchingDate(cronTab);
        HarvestingTimerTask harvestingTask = new HarvestingTimerTask();
        this.timer.schedule((TimerTask)harvestingTask, nextDate);
        this.registeredTasks.put(cronTab, harvestingTask);
        LOGGER.debug(String.format("Scheduled Tak '%s' will be next executed at %s", cronTab, nextDate.toString()));
    }

    private Response onAddTask(AddSchedulerTaskEvent event) {
        try {
            String cronTab = event.getCronTab();
            if (cronTab == null) {
                throw new IllegalArgumentException("Cannot add task. You must specify a valid cron tab as a query parameter 'cron'!");
            }
            if (this.registeredTasks.containsKey(cronTab)) {
                throw new IllegalArgumentException(String.format("Cannot add task, because it already exists: %s", cronTab));
            }
            this.scheduleTask(cronTab);
        }
        catch (IllegalArgumentException e) {
            return ServerResponseFactory.createBadRequestResponse(e.getMessage());
        }
        this.saveToDisk();
        return ServerResponseFactory.createResponse(Response.Status.CREATED, String.format("Successfully added task: %s", event.getCronTab()));
    }

    private Response onDeleteSchedule(DeleteSchedulerTaskEvent event) {
        String cronTab = event.getCronTab();
        if (cronTab == null) {
            this.timer.cancel();
            this.timer.purge();
            this.registeredTasks.clear();
            this.saveToDisk();
            this.timer = new Timer();
            return ServerResponseFactory.createOkResponse("Deleted all scheduled tasks!");
        }
        if (!this.registeredTasks.containsKey(cronTab)) {
            return ServerResponseFactory.createBadRequestResponse(String.format("Cannot remove task, because it does not exist: %s!", cronTab));
        }
        TimerTask removedTask = this.registeredTasks.remove(cronTab);
        removedTask.cancel();
        this.saveToDisk();
        return ServerResponseFactory.createOkResponse(String.format("Removed task: %s", cronTab));
    }

    private String onGetSchedule(GetScheduleEvent event) {
        StringBuilder sb = new StringBuilder();
        for (String cronTab : this.registeredTasks.keySet()) {
            sb.append(cronTab).append('\n');
        }
        return sb.toString();
    }

    private void onTaskExecuted(ScheduledTaskExecutedEvent event) {
        this.registeredTasks.forEach((cronTab, task) -> {
            if (task == event.getExecutedTask()) {
                try {
                    this.scheduleTask((String)cronTab);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Cannot re-schedule task: %s", cronTab), (Throwable)e);
                }
            }
        });
    }

    private void onContextDestroyed(ContextDestroyedEvent event) {
        this.timer.cancel();
        this.timer.purge();
        this.registeredTasks.clear();
    }
}

