/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.save;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.save.events.DocumentSavedEvent;
import de.gerdiproject.harvest.save.events.SaveFinishedEvent;
import de.gerdiproject.harvest.save.events.SaveStartedEvent;
import de.gerdiproject.harvest.save.events.StartSaveEvent;
import de.gerdiproject.harvest.state.events.AbortingFinishedEvent;
import de.gerdiproject.harvest.state.events.AbortingStartedEvent;
import de.gerdiproject.harvest.state.events.StartAbortingEvent;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.cache.FileUtils;
import de.gerdiproject.harvest.utils.cache.HarvesterCache;
import de.gerdiproject.harvest.utils.cache.HarvesterCacheManager;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestSaver {
    private static final HarvestSaver instance = new HarvestSaver();
    private CancelableFuture<Boolean> currentSavingProcess;
    private boolean isAborting;
    private File saveFile;
    private static final Logger LOGGER = LoggerFactory.getLogger(HarvestSaver.class);
    private final Consumer<StartSaveEvent> onStartSave = e -> this.save(e.isAutoTriggered());
    private final Consumer<StartAbortingEvent> onStartAborting = e -> {
        this.isAborting = true;
        EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
        EventSystem.sendEvent(new AbortingStartedEvent());
    };

    public static void init() {
        EventSystem.addListener(StartSaveEvent.class, HarvestSaver.instance.onStartSave);
    }

    private void save(boolean isAutoTriggered) {
        this.isAborting = false;
        EventSystem.addListener(StartAbortingEvent.class, this.onStartAborting);
        long startTimestamp = MainContext.getTimeKeeper().getHarvestMeasure().getStartTimestamp();
        long finishTimestamp = MainContext.getTimeKeeper().getHarvestMeasure().getEndTimestamp();
        this.currentSavingProcess = new CancelableFuture<Boolean>(this.createSaveProcess(startTimestamp, finishTimestamp, isAutoTriggered));
        ((CompletableFuture)this.currentSavingProcess.thenApply(isSuccessful -> {
            this.onSaveFinishedSuccessfully((boolean)isSuccessful);
            return isSuccessful;
        })).exceptionally(throwable -> {
            this.onSaveFailed((Throwable)throwable);
            return false;
        });
    }

    private void onSaveFinishedSuccessfully(boolean isSuccessful) {
        if (isSuccessful) {
            LOGGER.info("Saving done!");
        } else {
            LOGGER.info("Saving failed!");
        }
        this.currentSavingProcess = null;
        EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
        EventSystem.sendEvent(new SaveFinishedEvent(isSuccessful));
        if (this.isAborting) {
            this.isAborting = false;
            EventSystem.sendEvent(new AbortingFinishedEvent());
        }
    }

    private void onSaveFailed(Throwable reason) {
        if (this.saveFile != null) {
            FileUtils.deleteFile(this.saveFile);
        }
        this.currentSavingProcess = null;
        EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
        if (this.isAborting) {
            this.isAborting = false;
            EventSystem.sendEvent(new AbortingFinishedEvent());
        } else {
            LOGGER.error("Saving failed!", reason);
        }
        EventSystem.sendEvent(new SaveFinishedEvent(false));
    }

    private Callable<Boolean> createSaveProcess(long startTimestamp, long finishTimestamp, boolean isAutoTriggered) {
        return () -> {
            boolean isSuccessful;
            int documentCount = HarvesterCacheManager.instance().getNumberOfHarvestedDocuments();
            EventSystem.sendEvent(new SaveStartedEvent(isAutoTriggered, documentCount));
            if (documentCount == 0) {
                LOGGER.error("Could not save documents: There are no changes to save!");
                return false;
            }
            Configuration config = MainContext.getConfiguration();
            this.saveFile = this.createTargetFile(config, startTimestamp);
            boolean bl = isSuccessful = this.saveFile != null;
            if (isSuccessful) {
                LOGGER.info(String.format("Saving documents to: %s", this.saveFile.getAbsolutePath()));
                try {
                    JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.saveFile), MainContext.getCharset()));
                    this.writeDocuments(writer, startTimestamp, finishTimestamp, config.getParameterValue("readFromDisk", Boolean.class));
                }
                catch (IOException e) {
                    LOGGER.error("Saving interrupted unexpectedly!", (Throwable)e);
                    isSuccessful = false;
                }
            }
            return isSuccessful;
        };
    }

    private File createTargetFile(Configuration config, long startTimestamp) {
        int from = config.getParameterValue("harvestFrom", Integer.class);
        int to = config.getParameterValue("harvestTo", Integer.class);
        String fileName = from > 0 || to != Integer.MAX_VALUE ? String.format("harvestedIndices/%s_partialResult_%d-%d_%d.json", MainContext.getModuleName(), from, to, startTimestamp) : String.format("harvestedIndices/%s_result_%d.json", MainContext.getModuleName(), startTimestamp);
        File saveFile = new File(fileName);
        FileUtils.createEmptyFile(saveFile);
        return saveFile.exists() ? saveFile : null;
    }

    private void writeDocuments(JsonWriter writer, long startTimestamp, long finishTimestamp, boolean readFromDisk) throws IOException {
        DocumentSavedEvent savedEvent = new DocumentSavedEvent();
        writer.beginObject();
        writer.name("harvestDate");
        writer.value(startTimestamp);
        writer.name("durationInSeconds");
        writer.value((finishTimestamp - startTimestamp) / 1000L);
        writer.name("wasHarvestedFromDisk");
        writer.value(readFromDisk);
        writer.name("documents");
        writer.beginArray();
        Gson gson = GsonUtils.getGson();
        List<HarvesterCache> cacheList = HarvesterCacheManager.instance().getHarvesterCaches();
        for (HarvesterCache cache : cacheList) {
            cache.getChangesCache().forEach((documentId, document) -> {
                if (this.isAborting) {
                    return false;
                }
                if (document != null) {
                    gson.toJson(document, DataCiteJson.class, writer);
                }
                EventSystem.sendEvent(savedEvent);
                return true;
            });
        }
        writer.endArray();
        writer.endObject();
        writer.close();
        if (this.isAborting) {
            this.currentSavingProcess.cancel(false);
        }
    }
}

