/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.harvester;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.AbstractHarvester;
import de.gerdiproject.json.GsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public abstract class AbstractStreamHarvester<T>
extends AbstractHarvester {
    private final Class<T> entryClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private final AtomicInteger entryCount;
    protected final int numberOfDocumentsPerEntry;
    private final Consumer<ContextDestroyedEvent> onContextDestroyed = e -> this.deleteEntryStreamFile();

    public AbstractStreamHarvester(String harvesterName, int numberOfDocumentsPerEntry) {
        super(harvesterName);
        this.numberOfDocumentsPerEntry = numberOfDocumentsPerEntry;
        this.entryCount = new AtomicInteger();
        EventSystem.addListener(ContextDestroyedEvent.class, this.onContextDestroyed);
    }

    public AbstractStreamHarvester(int numberOfDocumentsPerEntry) {
        this(null, numberOfDocumentsPerEntry);
    }

    protected abstract void loadEntries(Consumer<T> var1);

    protected abstract List<IDocument> harvestEntry(T var1);

    @Override
    protected boolean harvestInternal(int from, int to) throws Exception {
        if (from == to) {
            this.logger.warn(String.format("Skipping %s - Document indices out of range.", this.name));
            return true;
        }
        if (this.entryCount.get() == 0) {
            this.logger.error(String.format("Cannot harvest %s - The source entries are empty or could not be retrieved!", this.name));
            return false;
        }
        int firstEntryIndex = from / this.numberOfDocumentsPerEntry;
        int lastEntryIndex = (to - 1) / this.numberOfDocumentsPerEntry;
        int startIndex = from % this.numberOfDocumentsPerEntry;
        int endIndex = to % this.numberOfDocumentsPerEntry;
        if (endIndex == 0) {
            endIndex = this.numberOfDocumentsPerEntry;
        }
        Gson gson = GsonUtils.getGson();
        JsonReader entryReader = this.createEntryStreamReader();
        entryReader.beginArray();
        int i = 0;
        while (entryReader.hasNext()) {
            if (this.isAborting) {
                this.currentHarvestingProcess.cancel(false);
                return false;
            }
            if (i >= firstEntryIndex) {
                int jEnd;
                Object entry = gson.fromJson(entryReader, this.entryClass);
                List<IDocument> docs = this.harvestEntry(entry);
                int j = i == firstEntryIndex ? startIndex : 0;
                int n = jEnd = i == lastEntryIndex ? endIndex : this.numberOfDocumentsPerEntry;
                if (docs != null) {
                    while (j < jEnd && j < docs.size()) {
                        this.addDocument(docs.get(j++));
                    }
                }
                while (j++ < jEnd) {
                    this.addDocument(null);
                }
                if (i == lastEntryIndex) break;
            }
            ++i;
        }
        if (!this.isAborting) {
            entryReader.endArray();
        }
        entryReader.close();
        return true;
    }

    @Override
    public void init() {
        this.deleteEntryStreamFile();
        try {
            this.writeEntriesToStream();
        }
        catch (IOException e) {
            this.logger.error(String.format("Could not write entries to file at path '%s'!", e));
        }
        super.init();
    }

    private void writeEntriesToStream() throws IOException {
        this.entryCount.set(0);
        JsonWriter entryWriter = this.createEntryStreamWriter();
        entryWriter.beginArray();
        Consumer<T> addFunction = this.createAddEntryToStreamFunction(entryWriter);
        this.loadEntries(addFunction);
        entryWriter.endArray();
        entryWriter.close();
    }

    private JsonWriter createEntryStreamWriter() throws FileNotFoundException {
        File cacheFile = this.getEntryStreamFile();
        if (cacheFile == null) {
            throw new FileNotFoundException();
        }
        return new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), MainContext.getCharset()));
    }

    private JsonReader createEntryStreamReader() throws FileNotFoundException {
        File cacheFile = this.getEntryStreamFile();
        if (cacheFile == null) {
            throw new FileNotFoundException();
        }
        return new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(cacheFile), MainContext.getCharset()));
    }

    private void deleteEntryStreamFile() {
        File cacheFile = this.getEntryStreamFile();
        if (cacheFile != null && cacheFile.exists()) {
            boolean deleteSuccess;
            try {
                deleteSuccess = cacheFile.delete();
            }
            catch (SecurityException e) {
                deleteSuccess = false;
            }
            if (deleteSuccess) {
                this.logger.info(String.format("Deleted file '%s'.", cacheFile.getName()));
            } else {
                this.logger.error(String.format("Could not delete file '%s'!", cacheFile.getName()));
            }
        }
    }

    protected File getEntryStreamFile() {
        boolean isDirectoryCreated;
        String filePath = String.format("cache/%s/StreamHarvester/%s.json", MainContext.getModuleName(), this.name);
        File cacheFile = new File(filePath);
        try {
            isDirectoryCreated = cacheFile.getParentFile().exists() || cacheFile.getParentFile().mkdirs();
        }
        catch (SecurityException e) {
            isDirectoryCreated = false;
        }
        return isDirectoryCreated ? cacheFile : null;
    }

    private Consumer<T> createAddEntryToStreamFunction(JsonWriter entryWriter) {
        return entry -> {
            GsonUtils.getGson().toJson(entry, entry.getClass(), entryWriter);
            this.entryCount.incrementAndGet();
        };
    }

    @Override
    protected int initMaxNumberOfDocuments() {
        return this.entryCount.get() * this.numberOfDocumentsPerEntry;
    }
}

