/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.harvester;

import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.events.HarvesterParameterChangedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.DocumentsHarvestedEvent;
import de.gerdiproject.harvest.harvester.events.GetHarvesterOutdatedEvent;
import de.gerdiproject.harvest.harvester.events.GetMaxDocumentCountEvent;
import de.gerdiproject.harvest.harvester.events.GetProviderNameEvent;
import de.gerdiproject.harvest.harvester.events.HarvestFinishedEvent;
import de.gerdiproject.harvest.harvester.events.HarvestStartedEvent;
import de.gerdiproject.harvest.harvester.events.StartHarvestEvent;
import de.gerdiproject.harvest.state.events.AbortingFinishedEvent;
import de.gerdiproject.harvest.state.events.AbortingStartedEvent;
import de.gerdiproject.harvest.state.events.StartAbortingEvent;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.cache.HarvesterCache;
import de.gerdiproject.harvest.utils.data.HttpRequester;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHarvester {
    private final Map<String, String> properties;
    private final AtomicInteger maxDocumentCount;
    private final AtomicInteger startIndex;
    private final AtomicInteger endIndex;
    private HarvesterCache documentsCache;
    protected CancelableFuture<Boolean> currentHarvestingProcess;
    protected boolean isMainHarvester;
    protected boolean isAborting;
    protected boolean isFailing;
    protected AtomicBoolean forceHarvest;
    protected String name;
    protected String hash;
    protected final HttpRequester httpRequester;
    protected final Logger logger;
    private final Consumer<StartAbortingEvent> onStartAborting = e -> {
        EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
        EventSystem.sendEvent(new AbortingStartedEvent());
        this.abortHarvest();
    };

    public AbstractHarvester() {
        this(null);
    }

    public AbstractHarvester(String harvesterName) {
        this.name = harvesterName != null ? harvesterName : this.getClass().getSimpleName();
        this.logger = LoggerFactory.getLogger((String)this.name);
        this.properties = new HashMap<String, String>();
        this.httpRequester = new HttpRequester();
        this.currentHarvestingProcess = null;
        this.maxDocumentCount = new AtomicInteger();
        this.startIndex = new AtomicInteger(0);
        this.endIndex = new AtomicInteger(0);
        this.forceHarvest = new AtomicBoolean(false);
    }

    protected abstract boolean harvestInternal(int var1, int var2) throws Exception;

    protected abstract int initMaxNumberOfDocuments();

    protected abstract String initHash() throws NoSuchAlgorithmException, NullPointerException;

    protected HarvesterCache initCache() {
        HarvesterCache cache = this.documentsCache != null ? this.documentsCache : new HarvesterCache(this.name);
        int from = this.startIndex.get() == Integer.MAX_VALUE ? this.maxDocumentCount.get() : this.startIndex.get();
        int to = this.endIndex.get() == Integer.MAX_VALUE ? this.maxDocumentCount.get() : this.endIndex.get();
        cache.init(this.hash, from, to);
        return cache;
    }

    protected void abortHarvest() {
        if (this.currentHarvestingProcess != null) {
            this.isAborting = true;
        }
    }

    public void init() {
        this.isFailing = false;
        try {
            this.hash = this.initHash();
        }
        catch (NullPointerException | NoSuchAlgorithmException e) {
            this.logger.error(String.format("Failed to create hash for %s!", this.name), (Throwable)e);
            this.hash = null;
            this.isFailing = true;
        }
        int maxHarvestableDocs = this.initMaxNumberOfDocuments();
        this.maxDocumentCount.set(maxHarvestableDocs);
        this.endIndex.set(maxHarvestableDocs);
        this.documentsCache = this.initCache();
    }

    public void setAsMainHarvester() {
        this.isMainHarvester = true;
        EventSystem.addListener(HarvesterParameterChangedEvent.class, this::onParameterChanged);
        EventSystem.addListener(StartHarvestEvent.class, this::onStartHarvest);
        EventSystem.addSynchronousListener(GetMaxDocumentCountEvent.class, this::onGetMaxDocumentCount);
        EventSystem.addSynchronousListener(GetProviderNameEvent.class, this::onGetDataProviderName);
        EventSystem.addSynchronousListener(GetHarvesterOutdatedEvent.class, this::onGetHarvesterOutdated);
    }

    protected String getProperty(String key) {
        return this.properties.get(key);
    }

    protected void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    protected void addDocument(IDocument document) {
        if (document != null) {
            if (document instanceof ICleanable) {
                ((ICleanable)document).clean();
            }
            if (this.forceHarvest.get()) {
                this.documentsCache.addDocument(document);
            } else {
                this.documentsCache.cacheDocument(document);
            }
        }
        EventSystem.sendEvent(DocumentsHarvestedEvent.singleHarvestedDocument());
    }

    protected final int getMaxNumberOfDocuments() {
        return this.maxDocumentCount.get();
    }

    protected void setStartIndex(int from) {
        if (this.startIndex.get() == from) {
            return;
        }
        if (from <= 0) {
            this.startIndex.set(0);
        } else {
            this.startIndex.set(from);
        }
        this.documentsCache = this.initCache();
    }

    protected void setEndIndex(int to) {
        if (this.endIndex.get() == to) {
            return;
        }
        if (to <= 0) {
            this.endIndex.set(0);
        } else {
            this.endIndex.set(to);
        }
        this.documentsCache = this.initCache();
    }

    protected void setForceHarvest(boolean state) {
        this.forceHarvest.set(state);
    }

    protected final void harvest() {
        int to;
        this.logger.info(String.format("Starting %s...", this.name));
        this.init();
        int from = this.startIndex.get() == Integer.MAX_VALUE ? this.maxDocumentCount.get() : this.startIndex.get();
        int n = to = this.endIndex.get() == Integer.MAX_VALUE ? this.maxDocumentCount.get() : this.endIndex.get();
        if (!this.forceHarvest.get()) {
            if (!this.isOutdated()) {
                this.logger.info(String.format("Skipping %s, because no changes were detected!", this.name));
                this.skipAllDocuments();
                return;
            }
            if (this.isMainHarvester && MainContext.getTimeKeeper().hasUnsubmittedChanges()) {
                this.logger.info(String.format("Cancelling %s, because previous changes have not been submitted!%nEither /submit the current index or set the 'forceHarvest' flag to true when harvesting.", this.name));
                this.skipAllDocuments();
                return;
            }
        }
        if (this.isMainHarvester) {
            EventSystem.addListener(StartAbortingEvent.class, this.onStartAborting);
            EventSystem.sendEvent(new HarvestStartedEvent(from, to));
        }
        this.currentHarvestingProcess = new CancelableFuture<Boolean>(() -> this.harvestInternal(from, to));
        ((CompletableFuture)this.currentHarvestingProcess.thenApply(isSuccessful -> {
            this.finishHarvestSuccessfully();
            return isSuccessful;
        })).exceptionally(throwable -> {
            this.finishHarvestExceptionally(throwable.getCause());
            return false;
        });
    }

    protected void finishHarvestSuccessfully() {
        this.currentHarvestingProcess = null;
        this.logger.info(String.format("%s finished!", this.name));
        if (this.isMainHarvester) {
            EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
            this.applyCacheChanges();
            EventSystem.sendEvent(new HarvestFinishedEvent(true, this.getHash(false)));
        }
        if (this.isAborting) {
            this.isAborting = false;
            if (this.isMainHarvester) {
                EventSystem.sendEvent(new AbortingFinishedEvent());
            }
        }
    }

    protected void finishHarvestExceptionally(Throwable reason) {
        this.currentHarvestingProcess = null;
        if (this.isAborting) {
            this.onHarvestAborted();
        } else {
            this.onHarvestFailed(reason);
        }
    }

    protected void onHarvestFailed(Throwable reason) {
        this.isFailing = true;
        this.logger.error(reason.getMessage(), reason);
        this.logger.warn(String.format("%s failed!", this.name));
        if (this.isMainHarvester) {
            EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
            this.applyCacheChanges();
            EventSystem.sendEvent(new HarvestFinishedEvent(false, this.getHash(false)));
        }
    }

    protected void onHarvestAborted() {
        if (this.isMainHarvester) {
            this.applyCacheChanges();
            EventSystem.sendEvent(new AbortingFinishedEvent());
        }
        this.isAborting = false;
        this.logger.warn(String.format("%s aborted!", this.name));
    }

    protected String getHash(boolean recalculate) {
        if (recalculate) {
            try {
                this.hash = this.initHash();
            }
            catch (NullPointerException | NoSuchAlgorithmException e) {
                this.logger.error(String.format("Failed to create hash for %s!", this.name), (Throwable)e);
            }
        }
        return this.hash;
    }

    protected boolean isOutdated() {
        return this.documentsCache.getVersionsCache().isOutdated();
    }

    protected void applyCacheChanges() {
        this.documentsCache.applyChanges(!this.isFailing, this.isAborting);
    }

    protected void skipAllDocuments() {
        this.documentsCache.skipAllDocuments();
        EventSystem.sendEvent(new DocumentsHarvestedEvent(this.getMaxNumberOfDocuments()));
    }

    private void onParameterChanged(HarvesterParameterChangedEvent event) {
        String key = event.getParameter().getKey();
        Object value = event.getParameter().getValue();
        if (key.equals("harvestFrom")) {
            this.setStartIndex((Integer)value);
        } else if (key.equals("harvestTo")) {
            this.setEndIndex((Integer)value);
        } else if (key.equals("forceHarvest")) {
            this.setForceHarvest((Boolean)value);
        } else if (value != null) {
            this.setProperty(key, value.toString());
        } else {
            this.setProperty(key, null);
        }
    }

    protected String onGetDataProviderName(GetProviderNameEvent event) {
        String name = this.getClass().getSimpleName();
        int harvesterIndex = name.toLowerCase().lastIndexOf("harvester");
        if (harvesterIndex != -1) {
            name = name.substring(0, harvesterIndex);
        }
        return name;
    }

    private Boolean onGetHarvesterOutdated(GetHarvesterOutdatedEvent event) {
        this.init();
        return this.isOutdated();
    }

    private void onStartHarvest(StartHarvestEvent event) {
        this.harvest();
    }

    private final Integer onGetMaxDocumentCount(GetMaxDocumentCountEvent event) {
        int beginning = this.startIndex.get();
        int end = this.endIndex.get();
        if (end == Integer.MAX_VALUE) {
            end = this.getMaxNumberOfDocuments();
        }
        return end - beginning;
    }
}

