/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.harvester;

import de.gerdiproject.harvest.harvester.AbstractHarvester;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.harvest.utils.cache.HarvesterCache;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class AbstractCompositeHarvester
extends AbstractHarvester {
    protected final Iterable<AbstractHarvester> subHarvesters;

    public AbstractCompositeHarvester(String harvesterName, Iterable<AbstractHarvester> subHarvesters) {
        super(harvesterName);
        this.subHarvesters = subHarvesters;
    }

    public AbstractCompositeHarvester(Iterable<AbstractHarvester> subHarvesters) {
        this(null, subHarvesters);
    }

    @Override
    protected void setStartIndex(int startIndex) {
        this.updateRangeIndex(startIndex, (h, index) -> h.setStartIndex((int)index));
    }

    @Override
    protected void setEndIndex(int endIndex) {
        this.updateRangeIndex(endIndex, (h, index) -> h.setEndIndex((int)index));
    }

    @Override
    protected void setForceHarvest(boolean state) {
        super.setForceHarvest(state);
        this.subHarvesters.forEach(subHarvester -> subHarvester.setForceHarvest(state));
    }

    private void updateRangeIndex(int index, BiConsumer<AbstractHarvester, Integer> indexSetter) {
        int numberOfProcessedDocs = 0;
        for (AbstractHarvester subHarvester : this.subHarvesters) {
            int numberOfSubDocs = subHarvester.getMaxNumberOfDocuments();
            int previouslyProcessedDocs = numberOfProcessedDocs;
            int subValue = index >= (numberOfProcessedDocs += numberOfSubDocs) ? Integer.MAX_VALUE : (index >= previouslyProcessedDocs ? index - previouslyProcessedDocs : Integer.MIN_VALUE);
            indexSetter.accept(subHarvester, subValue);
        }
    }

    @Override
    protected boolean harvestInternal(int from, int to) throws Exception {
        LinkedList subProcesses = new LinkedList();
        this.subHarvesters.forEach(subHarvester -> {
            subHarvester.harvest();
            CancelableFuture<Boolean> subHarvestingProcess = subHarvester.currentHarvestingProcess;
            if (subHarvestingProcess != null) {
                subProcesses.add(subHarvestingProcess);
            }
        });
        CompletableFuture[] futureArray = new CompletableFuture[subProcesses.size()];
        int len = futureArray.length;
        for (int i = 0; i < len; ++i) {
            futureArray[i] = (CompletableFuture)subProcesses.get(i);
        }
        CompletableFuture.allOf(futureArray).get();
        return true;
    }

    @Override
    public void init() {
        this.subHarvesters.forEach(subHarvester -> subHarvester.init());
        super.init();
    }

    @Override
    protected int initMaxNumberOfDocuments() {
        int total = 0;
        for (AbstractHarvester subHarvester : this.subHarvesters) {
            total += subHarvester.getMaxNumberOfDocuments();
        }
        return total;
    }

    @Override
    protected HarvesterCache initCache() {
        return null;
    }

    @Override
    protected String initHash() throws NoSuchAlgorithmException, NullPointerException {
        StringBuffer hashBuilder = new StringBuffer();
        this.subHarvesters.forEach(subHarvester -> hashBuilder.append(subHarvester.getHash(false)));
        return HashGenerator.instance().getShaHash(hashBuilder.toString());
    }

    @Override
    protected boolean isOutdated() {
        boolean hasOutdatedSubHarvesters = false;
        for (AbstractHarvester h : this.subHarvesters) {
            if (hasOutdatedSubHarvesters |= h.isOutdated()) break;
        }
        return hasOutdatedSubHarvesters;
    }

    @Override
    protected void applyCacheChanges() {
        this.subHarvesters.forEach(subHarvester -> subHarvester.applyCacheChanges());
    }

    @Override
    protected void skipAllDocuments() {
        this.subHarvesters.forEach(subHarvester -> subHarvester.skipAllDocuments());
    }

    @Override
    protected void abortHarvest() {
        this.isAborting = true;
        if (this.currentHarvestingProcess != null) {
            this.subHarvesters.forEach(sub -> sub.abortHarvest());
        }
    }
}

