/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import de.gerdiproject.harvest.config.constants.ConfigurationConstants;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.state.IState;
import java.text.ParseException;
import java.util.List;

public class IntegerParameter
extends AbstractParameter<Integer> {
    public IntegerParameter(String key, List<Class<? extends IState>> allowedStates, int defaultValue) {
        super(key, allowedStates, "max, min, 0, 1, ...");
        this.value = defaultValue;
    }

    public IntegerParameter(String key, int defaultValue) {
        super(key, ConfigurationConstants.HARVESTER_PARAM_ALLOWED_STATES, "max, min, 0, 1, ...");
        this.value = defaultValue;
    }

    @Override
    public String getStringValue() {
        if ((Integer)this.value == Integer.MAX_VALUE) {
            return "max";
        }
        if ((Integer)this.value == Integer.MIN_VALUE) {
            return "min";
        }
        return String.valueOf(this.value);
    }

    @Override
    public Integer stringToValue(String value) throws ParseException, ClassCastException {
        if (value == null) {
            return 0;
        }
        if (value.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (value.equals("min")) {
            return Integer.MIN_VALUE;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0) {
                throw new ClassCastException();
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ClassCastException();
        }
    }
}

