/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import de.gerdiproject.harvest.config.constants.ConfigurationConstants;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.state.IState;
import java.text.ParseException;
import java.util.List;

public class BooleanParameter
extends AbstractParameter<Boolean> {
    public BooleanParameter(String key, List<Class<? extends IState>> allowedStates, boolean defaultValue) {
        super(key, allowedStates, "0, 1, true, false");
        this.value = defaultValue;
    }

    public BooleanParameter(String key, boolean defaultValue) {
        super(key, ConfigurationConstants.HARVESTER_PARAM_ALLOWED_STATES, "0, 1, true, false");
        this.value = defaultValue;
    }

    @Override
    public Boolean stringToValue(String value) throws ParseException, ClassCastException {
        if (value == null) {
            return false;
        }
        if (ConfigurationConstants.BOOLEAN_VALID_VALUES_LIST.contains(value)) {
            return value.equals(ConfigurationConstants.BOOLEAN_VALID_VALUES_LIST.get(0)) || Boolean.parseBoolean(value);
        }
        throw new ClassCastException();
    }
}

