/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import de.gerdiproject.harvest.state.IState;
import java.text.ParseException;
import java.util.List;

public abstract class AbstractParameter<T> {
    protected T value;
    protected final transient String key;
    private final transient List<Class<? extends IState>> allowedStates;
    private final transient String allowedValues;

    public AbstractParameter(String key, List<Class<? extends IState>> allowedStates, String allowedValues) {
        this.key = key;
        this.allowedStates = allowedStates;
        this.allowedValues = allowedValues;
    }

    public abstract T stringToValue(String var1) throws ParseException, ClassCastException;

    public String getKey() {
        return this.key;
    }

    public final T getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value != null ? this.value.toString() : "";
    }

    public final String setValue(String value, IState currentState) {
        String returnMessage;
        if (currentState != null && !this.allowedStates.contains(currentState.getClass())) {
            returnMessage = String.format("Cannot change parameter '%s' during the %s-process.", this.key, currentState.getName());
        } else {
            try {
                this.value = this.stringToValue(value);
                returnMessage = String.format("Set parameter '%s' to '%s'.", this.key, this.getStringValue());
            }
            catch (ClassCastException e) {
                returnMessage = String.format("Cannot change parameter '%s' to '%s'. Allowed values are: %s", this.key, value, this.allowedValues);
            }
            catch (ParseException e) {
                returnMessage = e.getMessage();
            }
        }
        return returnMessage;
    }

    public String toString() {
        return this.getKey() + " : " + this.getStringValue();
    }
}

