/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.adapter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.ParameterFactory;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.config.parameters.UrlParameter;
import de.gerdiproject.json.GsonUtils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class ConfigurationAdapter
implements JsonDeserializer<Configuration>,
JsonSerializer<Configuration> {
    public static Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(Configuration.class, (Object)new ConfigurationAdapter()).create();
    }

    public Configuration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Map<String, AbstractParameter<?>> globalParameters = ParameterFactory.createDefaultParameters();
        Map<String, AbstractParameter<?>> harvesterParameters = ParameterFactory.createHarvesterParameters(null);
        JsonObject configJson = json.getAsJsonObject();
        JsonObject globalParamsJson = configJson.get("globalParameters").getAsJsonObject();
        globalParameters.forEach((key, value) -> {
            JsonElement valueJson = globalParamsJson.get(key);
            if (valueJson != null) {
                if (valueJson.getAsJsonPrimitive().isString()) {
                    ((AbstractParameter)globalParameters.get(key)).setValue(valueJson.getAsString(), null);
                } else {
                    ((AbstractParameter)globalParameters.get(key)).setValue(valueJson.toString(), null);
                }
            } else {
                ((AbstractParameter)globalParameters.get(key)).setValue(null, null);
            }
        });
        Set harvesterParamsJson = configJson.get("harvesterParameters").getAsJsonObject().entrySet();
        for (Map.Entry paramJson : harvesterParamsJson) {
            String key2 = (String)paramJson.getKey();
            JsonPrimitive valueJson = ((JsonElement)paramJson.getValue()).getAsJsonPrimitive();
            AbstractParameter param = null;
            if (valueJson.isBoolean()) {
                param = new BooleanParameter(key2, valueJson.getAsBoolean());
            } else if (valueJson.isNumber()) {
                param = new IntegerParameter(key2, valueJson.getAsInt());
            } else if (valueJson.isString()) {
                param = valueJson.getAsString().startsWith("%URL_PARAMETER%") ? new UrlParameter(key2, valueJson.getAsString()) : new StringParameter(key2, valueJson.getAsString());
            }
            if (param != null) {
                harvesterParameters.put(key2, param);
                continue;
            }
            throw new JsonParseException(String.format("Could not read configuration parameter value '%s' from key '%s'!", GsonUtils.getPrettyGson().toJson((JsonElement)paramJson.getValue()), key2));
        }
        return new Configuration(globalParameters, harvesterParameters);
    }

    public JsonElement serialize(Configuration src, Type typeOfSrc, JsonSerializationContext context) {
        Map<String, AbstractParameter<?>> globalParameters = src.getGlobalParameters();
        JsonObject globalParamsJson = new JsonObject();
        globalParameters.forEach((key, param) -> {
            if (param instanceof BooleanParameter) {
                globalParamsJson.addProperty(key, (Boolean)param.getValue());
            } else if (param instanceof IntegerParameter) {
                globalParamsJson.addProperty(key, (Number)((Integer)param.getValue()));
            } else if (param instanceof StringParameter) {
                globalParamsJson.addProperty(key, (String)param.getValue());
            } else if (param instanceof UrlParameter && param.getValue() != null) {
                globalParamsJson.addProperty(key, "%URL_PARAMETER%" + param.getValue().toString());
            }
        });
        Map<String, AbstractParameter<?>> harvesterParameters = src.getHarvesterParameters();
        JsonObject harvesterParamsJson = new JsonObject();
        harvesterParameters.forEach((key, param) -> {
            if (param instanceof BooleanParameter) {
                harvesterParamsJson.addProperty(key, (Boolean)param.getValue());
            } else if (param instanceof IntegerParameter) {
                harvesterParamsJson.addProperty(key, (Number)((Integer)param.getValue()));
            } else if (param instanceof StringParameter) {
                harvesterParamsJson.addProperty(key, (String)param.getValue());
            } else if (param instanceof UrlParameter && param.getValue() != null) {
                globalParamsJson.addProperty(key, "%URL_PARAMETER%" + param.getValue().toString());
            }
        });
        JsonObject configJson = new JsonObject();
        configJson.add("globalParameters", (JsonElement)globalParamsJson);
        configJson.add("harvesterParameters", (JsonElement)harvesterParamsJson);
        return configJson;
    }
}

