/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config;

import com.google.gson.JsonParseException;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.adapter.ConfigurationAdapter;
import de.gerdiproject.harvest.config.events.GlobalParameterChangedEvent;
import de.gerdiproject.harvest.config.events.HarvesterParameterChangedEvent;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.ParameterFactory;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.utils.data.DiskIO;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private Map<String, AbstractParameter<?>> globalParameters;
    String globalParameterFormat;
    private Map<String, AbstractParameter<?>> harvesterParameters;
    String harvesterParameterFormat;

    public Configuration(Map<String, AbstractParameter<?>> globalParameters, Map<String, AbstractParameter<?>> harvesterParameters) {
        this.globalParameters = globalParameters;
        this.harvesterParameters = harvesterParameters;
        this.globalParameterFormat = this.getPaddedKeyFormat(globalParameters);
        this.harvesterParameterFormat = this.getPaddedKeyFormat(harvesterParameters);
    }

    public Configuration(List<AbstractParameter<?>> harvesterParams) {
        this.globalParameters = ParameterFactory.createDefaultParameters();
        this.harvesterParameters = ParameterFactory.createHarvesterParameters(harvesterParams);
        this.globalParameterFormat = this.getPaddedKeyFormat(this.globalParameters);
        this.harvesterParameterFormat = this.getPaddedKeyFormat(this.harvesterParameters);
        this.updateAllParameters();
    }

    private String getPaddedKeyFormat(Map<String, ?> map) {
        AtomicInteger maxLength = new AtomicInteger(0);
        map.forEach((key, value) -> {
            int keyLength = key.length();
            if (keyLength > maxLength.get()) {
                maxLength.set(keyLength);
            }
        });
        return String.format("%%1$-%ds :  %%2$s%%n", maxLength.get());
    }

    public String getInfoString() {
        String modName = MainContext.getModuleName();
        String parameters = this.toString();
        String globalParamKeys = this.globalParameters.keySet().toString();
        globalParamKeys = globalParamKeys.substring(1, globalParamKeys.length() - 1);
        String harvesterParamKeys = this.harvesterParameters.keySet().toString();
        harvesterParamKeys = harvesterParamKeys.substring(1, harvesterParamKeys.length() - 1);
        String validValues = harvesterParamKeys + ", " + globalParamKeys;
        return String.format("- %s Configuration -%n%n%s%nGET   Returns either the entire configuration in pretty text, or%n      if '?key=xxx' is added, returns the value of parameter 'xxx'.%nPOST  Saves the current configuration to disk.%nPUT   Sets x-www-form-urlencoded parameters for the harvester.%n      Valid values: %s.%n", modName, parameters, validValues);
    }

    public void loadFromCache() {
        String path = Configuration.getConfigFilePath();
        String configJson = new DiskIO().getString(path);
        if (configJson == null) {
            LOGGER.error(String.format("Could not load configuration from '%s': %s", path, "No configuration exists!"));
        } else {
            try {
                Configuration config = (Configuration)ConfigurationAdapter.getGson().fromJson(configJson, Configuration.class);
                config.harvesterParameters.forEach((key, param) -> {
                    if (this.harvesterParameters.containsKey(key)) {
                        this.setParameter((String)key, param.getStringValue());
                    }
                });
                config.globalParameters.forEach((key, param) -> {
                    if (this.globalParameters.containsKey(key)) {
                        this.setParameter((String)key, param.getStringValue());
                    }
                });
                LOGGER.info(String.format("Loaded configuration from '%s'.", path));
            }
            catch (JsonParseException e) {
                LOGGER.error(String.format("Could not load configuration from '%s': %s", path, e.toString()));
            }
        }
    }

    public void loadFromEnvironmentVariables() {
        LOGGER.info("Searching for configuration from environment variables...");
        int suffixIndex = MainContext.getModuleName().indexOf("HarvesterService");
        String moduleName = suffixIndex != -1 ? MainContext.getModuleName().substring(0, suffixIndex) : MainContext.getModuleName();
        AtomicInteger changeCount = new AtomicInteger(0);
        Map<String, String> environmentVariables = System.getenv();
        this.harvesterParameters.forEach((key, param) -> {
            String envVal = (String)environmentVariables.get(String.format("GERDI_%S_%S", moduleName, key));
            if (envVal != null) {
                LOGGER.debug(this.setParameter((String)key, envVal));
                changeCount.incrementAndGet();
            }
        });
        this.globalParameters.forEach((key, param) -> {
            String envVal = (String)environmentVariables.get(String.format("GERDI_%S_%S", moduleName, key));
            if (envVal != null) {
                LOGGER.debug(this.setParameter((String)key, envVal));
                changeCount.incrementAndGet();
            }
        });
        LOGGER.info(String.format("Set %d parameter(s) from environment variables.", changeCount.get()));
    }

    public String saveToDisk() {
        String path = Configuration.getConfigFilePath();
        String configJson = ConfigurationAdapter.getGson().toJson((Object)this);
        return new DiskIO().writeStringToFile(path, configJson);
    }

    private static String getConfigFilePath() {
        return String.format("cache/%s/config.json", MainContext.getModuleName());
    }

    public <T> T getParameterValue(String key, Class<T> parameterType) {
        AbstractParameter<?> param = this.globalParameters.get(key);
        if (param == null) {
            param = this.harvesterParameters.get(key);
        }
        if (param != null && param.getValue() != null && param.getValue().getClass().equals(parameterType)) {
            return (T)param.getValue();
        }
        return null;
    }

    public String getParameterStringValue(String key) {
        AbstractParameter<?> param = this.globalParameters.get(key);
        if (param == null) {
            param = this.harvesterParameters.get(key);
        }
        if (param != null) {
            return param.getStringValue();
        }
        return null;
    }

    public String setParameter(String key, String value) {
        AbstractParameter<?> param = this.globalParameters.get(key);
        boolean isHarvesterParam = false;
        if (param == null) {
            param = this.harvesterParameters.get(key);
            isHarvesterParam = true;
        }
        if (param == null) {
            return String.format("Cannot change parameter '%s'. Unknown parameter!", key);
        }
        Object oldValue = param.getValue();
        String message = param.setValue(value, StateMachine.getCurrentState());
        if (isHarvesterParam) {
            EventSystem.sendEvent(new HarvesterParameterChangedEvent(param, oldValue));
        } else {
            EventSystem.sendEvent(new GlobalParameterChangedEvent(param, oldValue));
        }
        return message;
    }

    public void updateParameter(String key) {
        AbstractParameter<?> param = this.globalParameters.get(key);
        boolean isHarvesterParam = false;
        if (param == null) {
            param = this.harvesterParameters.get(key);
            isHarvesterParam = true;
        }
        if (param != null) {
            if (isHarvesterParam) {
                EventSystem.sendEvent(new HarvesterParameterChangedEvent(param, null));
            } else {
                EventSystem.sendEvent(new GlobalParameterChangedEvent(param, null));
            }
        }
    }

    public void updateAllParameters() {
        this.globalParameters.forEach((key, param) -> EventSystem.sendEvent(new GlobalParameterChangedEvent((AbstractParameter<?>)param, null)));
        this.harvesterParameters.forEach((key, param) -> EventSystem.sendEvent(new HarvesterParameterChangedEvent((AbstractParameter<?>)param, null)));
    }

    public String toString() {
        StringBuilder harvesterBuilder = new StringBuilder();
        this.harvesterParameters.forEach((key, param) -> harvesterBuilder.append(String.format(this.harvesterParameterFormat, key, param.getStringValue())));
        StringBuilder globalBuilder = new StringBuilder();
        this.globalParameters.forEach((key, param) -> globalBuilder.append(String.format(this.globalParameterFormat, key, param.getStringValue())));
        return String.format("Harvester Parameters:%n%s%nGlobal Parameters:%n%s", harvesterBuilder.toString(), globalBuilder.toString());
    }

    public Map<String, AbstractParameter<?>> getGlobalParameters() {
        return Collections.unmodifiableMap(this.globalParameters);
    }

    public Map<String, AbstractParameter<?>> getHarvesterParameters() {
        return Collections.unmodifiableMap(this.harvesterParameters);
    }
}

