/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application.rest;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.application.constants.StatusConstants;
import de.gerdiproject.harvest.application.enums.HealthStatus;
import de.gerdiproject.harvest.harvester.events.GetMaxDocumentCountEvent;
import de.gerdiproject.harvest.harvester.events.GetProviderNameEvent;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.impl.ErrorState;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.cache.HarvesterCacheManager;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import java.time.Instant;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="status")
public final class StatusFacade {
    @GET
    @Produces(value={"text/plain"})
    public String getInfo() {
        return String.format("- %s Extended REST Interface -%n%nGET          Returns this overview of possible HTTP calls.%nGET/state    Returns plain text describing what the service is doing.%nGET/health   Returns plain text that serves as a health check.%nGET/progress Returns two slash-separated numbers, representing the%n             progress of the current task, or N/A if idle.%nGET/max-documents Returns the max number of documents that can be%n                  harvested considering the harvesting range.%nGET/data-provider Returns the name of the data provider that is harvested.%nGET/harvested-documents Returns the number of harvested and currently%n                        cached documents.%nGET/versions     Returns a list of GeRDI Maven dependencies.%nGET/versions-all Returns a list of all Maven dependencies.", MainContext.getModuleName());
    }

    @GET
    @Path(value="state")
    @Produces(value={"text/plain"})
    public String getStateName() {
        return StateMachine.getCurrentState().getName();
    }

    @GET
    @Path(value="data-provider")
    @Produces(value={"text/plain"})
    public Response getDataProvider() {
        return ServerResponseFactory.createSynchronousEventResponse(new GetProviderNameEvent());
    }

    @GET
    @Path(value="max-documents")
    @Produces(value={"text/plain"})
    public Response getMaxDocumentCount() {
        Response resp = ServerResponseFactory.createSynchronousEventResponse(new GetMaxDocumentCountEvent());
        if (resp.getEntity().equals("-1")) {
            return ServerResponseFactory.createBadRequestResponse();
        }
        return resp;
    }

    @GET
    @Path(value="harvested-documents")
    @Produces(value={"text/plain"})
    public Response getHarvestedDocumentCount() {
        return ServerResponseFactory.createOkResponse(HarvesterCacheManager.instance().getNumberOfHarvestedDocuments());
    }

    @GET
    @Path(value="progress")
    @Produces(value={"text/plain"})
    public Response getProgress() {
        return StateMachine.getCurrentState().getProgress();
    }

    @GET
    @Path(value="harvest-timestamp")
    @Produces(value={"text/plain"})
    public Response getHarvestStartTimestamp() {
        long timestamp = MainContext.getTimeKeeper().getHarvestMeasure().getStartTimestamp();
        if (timestamp == -1L) {
            return ServerResponseFactory.createBadRequestResponse();
        }
        return ServerResponseFactory.createOkResponse(Instant.ofEpochMilli(timestamp).toString());
    }

    @GET
    @Path(value="health")
    @Produces(value={"text/plain"})
    public Response getHealth() {
        String status;
        IState currentState = StateMachine.getCurrentState();
        HealthStatus health = HealthStatus.OK;
        if (currentState instanceof ErrorState) {
            health = HealthStatus.FUBAR;
        } else {
            status = currentState.getStatusString();
            boolean hasHarvestFailed = status.contains(StatusConstants.FAILED_HARVEST_HEALTH_CHECK);
            if (hasHarvestFailed) {
                health = HealthStatus.HARVEST_FAILED;
            } else {
                boolean hasSavingFailed = status.contains(StatusConstants.FAILED_SAVE_HEALTH_CHECK);
                boolean hasSubmissionFailed = status.contains(StatusConstants.FAILED_SUBMISSION_HEALTH_CHECK);
                if (hasSavingFailed && hasSubmissionFailed) {
                    health = HealthStatus.SAVING_AND_SUBMISSION_FAILED;
                } else if (hasSavingFailed) {
                    health = HealthStatus.SAVING_FAILED;
                } else if (hasSubmissionFailed) {
                    health = HealthStatus.SUBMISSION_FAILED;
                }
            }
        }
        status = health == HealthStatus.OK ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return ServerResponseFactory.createResponse((Response.Status)status, (Object)health);
    }

    @GET
    @Path(value="versions")
    @Produces(value={"text/plain"})
    public Response getVersions() {
        String versions = this.getSpecifiedVersions("de.gerdi-project");
        if (versions == null) {
            return ServerResponseFactory.createUnknownErrorResponse();
        }
        return ServerResponseFactory.createOkResponse(versions);
    }

    @GET
    @Path(value="versions-all")
    @Produces(value={"text/plain"})
    public Response getAllVersions() {
        String versions = this.getSpecifiedVersions(null);
        if (versions == null) {
            return ServerResponseFactory.createUnknownErrorResponse();
        }
        return ServerResponseFactory.createOkResponse(versions);
    }

    private String getSpecifiedVersions(String filter) {
        String mainJar = MavenUtils.instance().getHarvesterJarName();
        if (mainJar == null) {
            return null;
        }
        List<String> dependencyList = MavenUtils.instance().getMavenVersionInfo(filter);
        if (dependencyList == null) {
            return null;
        }
        dependencyList.remove(mainJar);
        return String.format("%s%n%n%s", mainJar, String.join((CharSequence)"\n", dependencyList));
    }
}

