/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest;

import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.AbstractHarvester;
import de.gerdiproject.harvest.harvester.events.HarvesterInitializedEvent;
import de.gerdiproject.harvest.save.HarvestSaver;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.impl.InitializationState;
import de.gerdiproject.harvest.submission.AbstractSubmitter;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.harvest.utils.time.HarvestTimeKeeper;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainContext {
    private String moduleName;
    private static final Logger LOGGER = LoggerFactory.getLogger(MainContext.class);
    private HarvestTimeKeeper timeKeeper;
    private AbstractHarvester harvester;
    private Charset charset;
    private Configuration configuration;
    private AbstractSubmitter submitter;
    private Scheduler scheduler;
    private static MainContext instance = new MainContext();
    private static Function<Boolean, Boolean> onHarvesterInitializedSuccess = state -> {
        LOGGER.info(String.format("%s initialized!", MainContext.getModuleName()));
        EventSystem.sendEvent(new HarvesterInitializedEvent((boolean)state));
        return state;
    };
    private static Function<Throwable, Boolean> onHarvesterInitializedFailed = reason -> {
        LOGGER.error("Could not initialize Harvester!", reason.getCause());
        EventSystem.sendEvent(new HarvesterInitializedEvent(false));
        return false;
    };

    private MainContext() {
    }

    public static String getModuleName() {
        return MainContext.instance.moduleName;
    }

    public static Charset getCharset() {
        return MainContext.instance.charset;
    }

    public static Configuration getConfiguration() {
        return MainContext.instance.configuration;
    }

    public static HarvestTimeKeeper getTimeKeeper() {
        return MainContext.instance.timeKeeper;
    }

    public static <T extends AbstractHarvester> void init(String moduleName, Class<T> harvesterClass, Charset charset, List<AbstractParameter<?>> harvesterParams, AbstractSubmitter submitter) {
        MainContext.instance.moduleName = moduleName;
        MainContext.instance.charset = charset;
        MainContext.instance.timeKeeper = new HarvestTimeKeeper();
        MainContext.instance.timeKeeper.init();
        StateMachine.setState(new InitializationState());
        CancelableFuture<Boolean> initProcess = new CancelableFuture<Boolean>(() -> {
            LOGGER.info("Initializing Harvester...");
            HashGenerator.init(charset);
            HarvestSaver.init();
            MainContext.instance.submitter = submitter;
            MainContext.instance.submitter.init();
            MainContext.instance.harvester = (AbstractHarvester)harvesterClass.newInstance();
            MainContext.instance.harvester.setAsMainHarvester();
            Configuration config = new Configuration(harvesterParams);
            config.loadFromEnvironmentVariables();
            config.loadFromCache();
            MainContext.instance.configuration = config;
            MainContext.instance.harvester.init();
            config.updateParameter("harvestFrom");
            config.updateParameter("harvestTo");
            MainContext.instance.scheduler = new Scheduler();
            MainContext.instance.scheduler.init();
            return true;
        });
        ((CompletableFuture)initProcess.thenApply(onHarvesterInitializedSuccess)).exceptionally(onHarvesterInitializedFailed);
    }
}

