/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest;

import com.google.gson.GsonBuilder;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.application.events.ContextInitializedEvent;
import de.gerdiproject.harvest.application.events.ContextResetEvent;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.AbstractHarvester;
import de.gerdiproject.harvest.submission.AbstractSubmitter;
import de.gerdiproject.harvest.submission.elasticsearch.ElasticSearchSubmitter;
import de.gerdiproject.harvest.utils.cache.HarvesterCacheManager;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import de.gerdiproject.json.GsonUtils;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextListener<T extends AbstractHarvester>
implements ServletContextListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContextListener.class);
    private Class<T> harvesterClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    protected String getServiceName() {
        String name = this.harvesterClass.getSimpleName();
        int harvesterIndex = name.toLowerCase().lastIndexOf("harvester");
        if (harvesterIndex != -1) {
            name = name.substring(0, harvesterIndex);
        }
        return name + "HarvesterService";
    }

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    protected GsonBuilder createGsonBuilder() {
        return new GsonBuilder();
    }

    protected List<AbstractParameter<?>> getHarvesterSpecificParameters() {
        return null;
    }

    protected AbstractSubmitter createSubmitter() {
        return new ElasticSearchSubmitter();
    }

    public void contextInitialized(ServletContextEvent sce) {
        EventSystem.addListener(ContextResetEvent.class, this::onContextReset);
        GsonUtils.init((GsonBuilder)this.createGsonBuilder());
        MavenUtils.instance().init(this);
        MainContext.init(this.getServiceName(), this.harvesterClass, this.getCharset(), this.getHarvesterSpecificParameters(), this.createSubmitter());
        EventSystem.sendEvent(new ContextInitializedEvent());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        EventSystem.sendEvent(new ContextDestroyedEvent());
        String goodbyeMsg = String.format("%s undeployed!", this.getServiceName());
        System.out.println(goodbyeMsg);
    }

    protected void onContextReset(ContextResetEvent event) {
        String resetMsg = String.format("Resetting %s...", this.getServiceName());
        LOGGER.info(resetMsg);
        EventSystem.reset();
        HarvesterCacheManager.instance().reset();
        this.contextInitialized(null);
    }
}

