/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.utils;

import com.google.gson.Gson;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import de.gerdiproject.json.GsonUtils;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryCleaner.class);
    private static final Gson GEO_GSON = GsonUtils.createGeoJsonGsonBuilder().create();

    public static Geometry validate(Geometry geo) {
        Geometry validGeo;
        if (geo == null) {
            return null;
        }
        String geoType = geo.getGeometryType();
        if (geoType.equalsIgnoreCase("Polygon") || geoType.equalsIgnoreCase("MultiPolygon")) {
            if (geo.isValid()) {
                validGeo = geo.norm();
            } else {
                try {
                    validGeo = GeometryCleaner.validatePolygon(geo);
                }
                catch (TopologyException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Skipped GeoJson, because it cannot be validated: %s", GEO_GSON.toJson((Object)geo)));
                    } else if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("Skipped %s GeoJson, because it cannot be validated.", geo.getGeometryType()));
                    }
                    validGeo = null;
                }
            }
        } else {
            validGeo = geo;
        }
        return validGeo;
    }

    private static Geometry validatePolygon(Geometry geo) {
        Geometry mergedPoly = null;
        int polygonCount = geo.getNumGeometries();
        for (int i = 0; i < polygonCount; ++i) {
            Polygon polygon = (Polygon)geo.getGeometryN(i);
            Geometry poly = GeometryCleaner.createValidPolygon(polygon.getExteriorRing());
            int holeCount = polygon.getNumInteriorRing();
            for (int j = 0; j < holeCount; ++j) {
                Geometry intersection;
                Geometry hole = GeometryCleaner.createValidPolygon(polygon.getInteriorRingN(j));
                if (hole == null || (intersection = GeometryCleaner.geometryToPolygon(poly.intersection(hole))) == null) continue;
                poly = poly.symDifference(intersection);
            }
            if (mergedPoly == null) {
                mergedPoly = poly;
                continue;
            }
            if (poly == null) continue;
            mergedPoly = mergedPoly.union(poly);
        }
        return mergedPoly;
    }

    private static Geometry validateLineString(LineString lineString) {
        GeometryFactory factory = lineString.getFactory();
        LineString realLineString = lineString instanceof LinearRing ? factory.createLineString(lineString.getCoordinateSequence()) : lineString;
        return realLineString.union();
    }

    private static Geometry createValidPolygon(LineString lineString) {
        Geometry polygonGeo;
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(GeometryCleaner.validateLineString(lineString));
        List polygons = (List)polygonizer.getPolygons();
        if (polygons.isEmpty()) {
            polygonGeo = null;
        } else {
            Iterator iter = polygons.iterator();
            polygonGeo = (Geometry)iter.next();
            while (iter.hasNext()) {
                Polygon hole = (Polygon)iter.next();
                Geometry mergedPoly = GeometryCleaner.geometryToPolygon(polygonGeo.symDifference((Geometry)hole));
                if (mergedPoly == null) continue;
                polygonGeo = mergedPoly;
            }
        }
        return polygonGeo;
    }

    private static Geometry geometryToPolygon(Geometry geo) {
        if (geo == null) {
            return null;
        }
        Geometry poly = null;
        String geoType = geo.getGeometryType();
        if (geoType.equalsIgnoreCase("Polygon") || geoType.equalsIgnoreCase("MultiPolygon")) {
            poly = geo;
        } else if (geo.getGeometryType().equalsIgnoreCase("GeometryCollection")) {
            int len = geo.getNumGeometries();
            for (int i = 0; i < len; ++i) {
                Geometry innerGeo = geo.getGeometryN(i);
                geoType = innerGeo.getGeometryType();
                if (!geoType.equalsIgnoreCase("Polygon") && !geoType.equalsIgnoreCase("MultiPolygon")) continue;
                poly = innerGeo;
                break;
            }
        }
        return poly;
    }

    private GeometryCleaner() {
    }
}

