/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import de.gerdiproject.json.geo.adapters.AbstractGeometryAdapter;
import java.util.Iterator;

public class PolygonAdapter
extends AbstractGeometryAdapter<Polygon> {
    public PolygonAdapter(GeometryFactory geoFactory) {
        super(geoFactory);
    }

    @Override
    protected JsonArray serializeCoordinates(Polygon src) {
        LineString hull = src.getExteriorRing();
        if (hull == null || hull.getCoordinates().length < 4) {
            return null;
        }
        JsonArray jsonCoordinates = new JsonArray();
        jsonCoordinates.add((JsonElement)this.coordinatesToJsonArray(hull.getCoordinates()));
        int holeCount = src.getNumInteriorRing();
        for (int i = 0; i < holeCount; ++i) {
            Coordinate[] holeCoordinates = src.getInteriorRingN(i).getCoordinates();
            jsonCoordinates.add((JsonElement)this.coordinatesToJsonArray(holeCoordinates));
        }
        return jsonCoordinates;
    }

    @Override
    protected Polygon deserializeGeometry(JsonArray jsonCoordinates, GeometryFactory factory) {
        Iterator jsonIter = jsonCoordinates.iterator();
        Coordinate[] hullCoordinates = this.jsonArrayToCoordinates(((JsonElement)jsonIter.next()).getAsJsonArray());
        LinearRing hull = factory.createLinearRing(hullCoordinates);
        int holeCount = jsonCoordinates.size() - 1;
        LinearRing[] holes = new LinearRing[holeCount];
        for (int i = 0; i < holeCount; ++i) {
            Coordinate[] holeCoordinates = this.jsonArrayToCoordinates(((JsonElement)jsonIter.next()).getAsJsonArray());
            holes[i] = factory.createLinearRing(holeCoordinates);
        }
        return factory.createPolygon(hull, holes);
    }
}

