/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.lang.reflect.Type;

public class GeometryAdapter
implements JsonSerializer<Geometry>,
JsonDeserializer<Geometry> {
    public JsonElement serialize(Geometry src, Type typeOfSrc, JsonSerializationContext context) {
        String geometryType;
        switch (geometryType = src.getGeometryType()) {
            case "Point": {
                return context.serialize((Object)src, Point.class);
            }
            case "MultiPoint": {
                return context.serialize((Object)src, MultiPoint.class);
            }
            case "LineString": {
                return context.serialize((Object)src, LineString.class);
            }
            case "MultiLineString": {
                return context.serialize((Object)src, MultiLineString.class);
            }
            case "Polygon": {
                return context.serialize((Object)src, Polygon.class);
            }
            case "MultiPolygon": {
                return context.serialize((Object)src, MultiPolygon.class);
            }
        }
        throw new JsonParseException(String.format("Unknown Geometry type '%s'.", geometryType));
    }

    public Geometry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String geometryType;
        switch (geometryType = json.getAsJsonObject().get("type").getAsString()) {
            case "Point": {
                return (Geometry)context.deserialize(json, Point.class);
            }
            case "MultiPoint": {
                return (Geometry)context.deserialize(json, MultiPoint.class);
            }
            case "LineString": {
                return (Geometry)context.deserialize(json, LineString.class);
            }
            case "MultiLineString": {
                return (Geometry)context.deserialize(json, MultiLineString.class);
            }
            case "Polygon": {
                return (Geometry)context.deserialize(json, Polygon.class);
            }
            case "MultiPolygon": {
                return (Geometry)context.deserialize(json, MultiPolygon.class);
            }
        }
        throw new JsonParseException(String.format("Unknown Geometry type '%s'.", geometryType));
    }
}

