/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import com.google.gson.annotations.SerializedName;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.harvest.utils.CollectionUtils;
import de.gerdiproject.json.geo.utils.GeometryCleaner;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GeoLocation
implements ICleanable {
    private static final GeometryFactory FACTORY = new GeometryFactory();
    @SerializedName(value="geoLocationPlace")
    private String place;
    @SerializedName(value="geoLocationPoint")
    private Point point;
    @SerializedName(value="geoLocationBox")
    private Polygon box;
    @SerializedName(value="geoLocationPolygon")
    private Set<Polygon> polygons;

    public GeoLocation(String place) {
        this.place = place;
    }

    public void setBox(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(westBoundLongitude, northBoundLatitude), new Coordinate(eastBoundLongitude, northBoundLatitude), new Coordinate(eastBoundLongitude, southBoundLatitude), new Coordinate(westBoundLongitude, southBoundLatitude), new Coordinate(westBoundLongitude, northBoundLatitude)};
        this.box = FACTORY.createPolygon(coordinates);
    }

    public void setBox(Geometry geometry) {
        this.box = geometry == null ? null : (Polygon)geometry.getEnvelope().convexHull();
    }

    public void setPoint(double longitude, double latitude) {
        this.point = FACTORY.createPoint(new Coordinate(longitude, latitude));
    }

    public void addPolygons(Collection<Geometry> geoList) {
        if (geoList == null) {
            return;
        }
        Iterator<Geometry> iter = geoList.iterator();
        LinkedList<Polygon> polyList = new LinkedList<Polygon>();
        while (iter.hasNext()) {
            Geometry geo = iter.next();
            if (geo == null) continue;
            String geoType = geo.getGeometryType();
            if (geoType.equalsIgnoreCase("Polygon")) {
                polyList.add((Polygon)geo);
                continue;
            }
            if (!geoType.equalsIgnoreCase("MultiPolygon")) continue;
            polyList.addAll(GeoLocation.multiPolygonToPolygonList((MultiPolygon)geo));
        }
        this.polygons = CollectionUtils.addToSet(this.polygons, polyList);
    }

    @Override
    public boolean clean() {
        this.cleanPoint();
        this.cleanPolygons();
        this.cleanBox();
        return this.isValid();
    }

    private void cleanPoint() {
        if (this.point != null && !this.point.isValid()) {
            this.point = null;
        }
    }

    private void cleanPolygons() {
        if (this.polygons == null) {
            return;
        }
        HashSet<Polygon> cleanedPolys = new HashSet<Polygon>();
        for (Polygon poly : this.polygons) {
            Geometry cleanedPoly = GeometryCleaner.validate((Geometry)poly);
            if (cleanedPoly == null) continue;
            if (cleanedPoly.getGeometryType().equalsIgnoreCase("Polygon")) {
                cleanedPolys.add((Polygon)cleanedPoly);
                continue;
            }
            if (!cleanedPoly.getGeometryType().equalsIgnoreCase("MultiPolygon")) continue;
            cleanedPolys.addAll(GeoLocation.multiPolygonToPolygonList((MultiPolygon)cleanedPoly));
        }
        this.polygons = CollectionUtils.addToSet(null, cleanedPolys);
    }

    private void cleanBox() {
        Coordinate cornerCoordinate2;
        Coordinate[] boxCoordinates;
        Coordinate cornerCoordinate1;
        if (this.box == null) {
            return;
        }
        Polygon newBoxValue = null;
        if (this.box.isRectangle() && !(cornerCoordinate1 = (boxCoordinates = this.box.getCoordinates())[1]).equals((Object)(cornerCoordinate2 = boxCoordinates[2]))) {
            newBoxValue = (Polygon)GeometryCleaner.validate((Geometry)this.box);
        }
        this.box = newBoxValue;
    }

    public boolean isValid() {
        return this.place != null || this.box != null || this.polygons != null && !this.polygons.isEmpty() || this.point != null;
    }

    private static List<Polygon> multiPolygonToPolygonList(MultiPolygon multiPolygon) {
        LinkedList<Polygon> list = new LinkedList<Polygon>();
        if (multiPolygon != null) {
            int len = multiPolygon.getNumGeometries();
            for (int i = 0; i < len; ++i) {
                Polygon poly = (Polygon)multiPolygon.getGeometryN(i);
                if (poly == null) continue;
                list.add(poly);
            }
        }
        return list;
    }

    public String getPlace() {
        return this.place;
    }

    public Point getPoint() {
        return this.point;
    }

    public Polygon getBox() {
        return this.box;
    }

    public Set<Polygon> getPolygons() {
        return this.polygons;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        Point this$point = this.getPoint();
        Point other$point = other.getPoint();
        if (this$point == null ? other$point != null : !this$point.equals(other$point)) {
            return false;
        }
        Polygon this$box = this.getBox();
        Polygon other$box = other.getBox();
        if (this$box == null ? other$box != null : !this$box.equals(other$box)) {
            return false;
        }
        Set<Polygon> this$polygons = this.getPolygons();
        Set<Polygon> other$polygons = other.getPolygons();
        return !(this$polygons == null ? other$polygons != null : !((Object)this$polygons).equals(other$polygons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        Point $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : $point.hashCode());
        Polygon $box = this.getBox();
        result = result * 59 + ($box == null ? 43 : $box.hashCode());
        Set<Polygon> $polygons = this.getPolygons();
        result = result * 59 + ($polygons == null ? 43 : ((Object)$polygons).hashCode());
        return result;
    }

    public String toString() {
        return "GeoLocation(place=" + this.getPlace() + ", point=" + this.getPoint() + ", box=" + this.getBox() + ", polygons=" + this.getPolygons() + ")";
    }

    public GeoLocation() {
    }
}

