/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import de.gerdiproject.json.DateRangeUtils;
import de.gerdiproject.json.DateUtils;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import de.gerdiproject.json.datacite.enums.DateType;
import java.time.Instant;
import java.time.ZonedDateTime;

public class DateRange
extends AbstractDate {
    private Instant since;
    private Instant until;

    public DateRange(String dateString, DateType type) {
        super(type);
        this.setValue(dateString);
    }

    public DateRange(long epochMilliSince, long epochMilliUntil, DateType type) {
        super(type);
        this.setRangeFrom(epochMilliSince);
        this.setRangeUntil(epochMilliUntil);
    }

    public DateRange(String rangeFrom, String rangeUntil, DateType type) {
        super(type);
        this.setRangeFrom(rangeFrom);
        this.setRangeUntil(rangeUntil);
    }

    @Override
    public String getValue() {
        if (this.since == null && this.until == null) {
            return null;
        }
        String sinceVal = this.since == null ? "" : this.since.toString();
        String untilVal = this.until == null ? "" : this.until.toString();
        return String.format("%s/%s", sinceVal, untilVal);
    }

    @Override
    public void setValue(String stringValue) {
        Instant[] dates = DateRangeUtils.parseDateRange(stringValue);
        if (dates == null) {
            this.since = null;
            this.until = null;
        } else {
            this.since = dates[0];
            this.until = dates[1];
        }
    }

    public ZonedDateTime getRangeFromAsDateTime() {
        return this.since == null ? null : ZonedDateTime.ofInstant(this.since, DataCiteDateConstants.Z_ZONE_ID);
    }

    public void setRangeFrom(long epochMilli) {
        this.since = DateUtils.unixTimestampToInstant(epochMilli);
    }

    public void setRangeFrom(String stringValue) {
        this.since = DateUtils.parseDate(stringValue);
    }

    public ZonedDateTime getRangeUntilAsDateTime() {
        return this.until == null ? null : ZonedDateTime.ofInstant(this.until, DataCiteDateConstants.Z_ZONE_ID);
    }

    public void setRangeUntil(long epochMilli) {
        this.until = DateUtils.unixTimestampToInstant(epochMilli);
    }

    public void setRangeUntil(String stringValue) {
        this.until = DateUtils.parseDate(stringValue);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Instant this$since = this.since;
        Instant other$since = other.since;
        if (this$since == null ? other$since != null : !((Object)this$since).equals(other$since)) {
            return false;
        }
        Instant this$until = this.until;
        Instant other$until = other.until;
        return !(this$until == null ? other$until != null : !((Object)this$until).equals(other$until));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DateRange;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Instant $since = this.since;
        result = result * 59 + ($since == null ? 43 : ((Object)$since).hashCode());
        Instant $until = this.until;
        result = result * 59 + ($until == null ? 43 : ((Object)$until).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DateRange(super=" + super.toString() + ", since=" + this.since + ", until=" + this.until + ")";
    }
}

