/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json;

import de.gerdiproject.json.DateUtils;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import java.time.Instant;
import java.util.Iterator;

public class DateRangeUtils {
    public static Instant[] parseDateRange(String dateString) {
        String separator;
        Instant[] dates = null;
        Iterator<String> iterator = DataCiteDateConstants.DATE_RANGE_SEPARATORS.iterator();
        while (iterator.hasNext() && (dates = DateRangeUtils.parseDateRange(dateString, separator = iterator.next())) == null) {
        }
        return dates;
    }

    public static Instant[] parseDateRange(String dateString, String separator) {
        Instant[] dates = new Instant[2];
        boolean isDateRange = false;
        if (dateString.contains(separator)) {
            String dateStringFrom = null;
            String dateStringUntil = null;
            if (dateString.startsWith(separator)) {
                dateStringUntil = dateString.substring(separator.length());
            } else if (dateString.endsWith(separator)) {
                dateStringFrom = dateString.substring(0, dateString.length() - separator.length());
            } else {
                String[] dateRangeElements = dateString.split(separator);
                if (dateRangeElements.length == 2) {
                    dateStringFrom = dateRangeElements[0];
                    dateStringUntil = dateRangeElements[1];
                } else if (dateRangeElements.length > 2 && dateRangeElements.length % 2 == 0) {
                    int separatorLength = separator.length();
                    int halfLength = 0;
                    int len = dateRangeElements.length / 2;
                    for (int i = 0; i < len; ++i) {
                        halfLength += dateRangeElements[i].length() + separatorLength;
                    }
                    dateStringFrom = dateString.substring(0, halfLength - 1);
                    dateStringUntil = dateString.substring(halfLength);
                }
            }
            if (dateStringFrom != null || dateStringUntil != null) {
                boolean bl = isDateRange = dateStringFrom == null || dateStringUntil == null || Math.abs(dateStringFrom.length() - dateStringUntil.length()) <= 2;
                if (dateStringFrom != null) {
                    dates[0] = DateUtils.parseDate(dateStringFrom);
                    isDateRange &= dates[0] != null;
                }
                if (dateStringUntil != null) {
                    dates[1] = DateUtils.parseDate(dateStringUntil);
                    isDateRange &= dates[1] != null;
                }
            }
        }
        return isDateRange ? dates : null;
    }

    private DateRangeUtils() {
    }
}

