/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.gerdiproject.json.geo.GeoJson;
import de.gerdiproject.json.geo.IGeoCoordinates;
import de.gerdiproject.json.geo.LineString;
import de.gerdiproject.json.geo.MultiLineString;
import de.gerdiproject.json.geo.MultiPoint;
import de.gerdiproject.json.geo.MultiPolygon;
import de.gerdiproject.json.geo.Point;
import de.gerdiproject.json.geo.Polygon;
import java.lang.reflect.Type;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsonAdapter
implements JsonDeserializer<GeoJson> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoJson.class);

    public GeoJson deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        IGeoCoordinates coordinates;
        JsonObject geoJsonRaw = json.getAsJsonObject();
        String type = geoJsonRaw.get("type").getAsString().toLowerCase(Locale.ENGLISH);
        JsonArray coordinatesRaw = geoJsonRaw.get("coordinates").getAsJsonArray();
        try {
            switch (type) {
                case "point": {
                    coordinates = (IGeoCoordinates)context.deserialize((JsonElement)coordinatesRaw, Point.class);
                    break;
                }
                case "multipoint": {
                    coordinates = (IGeoCoordinates)context.deserialize((JsonElement)coordinatesRaw, MultiPoint.class);
                    break;
                }
                case "linestring": {
                    coordinates = (IGeoCoordinates)context.deserialize((JsonElement)coordinatesRaw, LineString.class);
                    break;
                }
                case "multilinestring": {
                    coordinates = (IGeoCoordinates)context.deserialize((JsonElement)coordinatesRaw, MultiLineString.class);
                    break;
                }
                case "polygon": {
                    coordinates = (IGeoCoordinates)context.deserialize((JsonElement)coordinatesRaw, Polygon.class);
                    break;
                }
                case "multipolygon": {
                    coordinates = (IGeoCoordinates)context.deserialize((JsonElement)coordinatesRaw, MultiPolygon.class);
                    break;
                }
                default: {
                    throw new JsonParseException(String.format("Unknown GeoJson type '%s'!", type));
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Could not parse GeoJson!", (Throwable)e);
            return null;
        }
        return new GeoJson(coordinates);
    }
}

