/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo;

import com.google.gson.JsonArray;
import de.gerdiproject.json.geo.IGeoCoordinates;

public class Point
implements IGeoCoordinates {
    private final double longitude;
    private final double latitude;
    private final double elevation;

    public Point(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.elevation = Double.NaN;
    }

    public Point(JsonArray array) throws ClassCastException, IllegalStateException, IndexOutOfBoundsException {
        double elevation = array.size() >= 3 ? array.get(2).getAsDouble() : Double.NaN;
        this.longitude = array.get(0).getAsDouble();
        this.latitude = array.get(1).getAsDouble();
        this.elevation = elevation;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getElevation() {
        return this.elevation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        return Double.compare(this.getElevation(), other.getElevation()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $elevation = Double.doubleToLongBits(this.getElevation());
        result = result * 59 + (int)($elevation >>> 32 ^ $elevation);
        return result;
    }

    public String toString() {
        return "Point(longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", elevation=" + this.getElevation() + ")";
    }

    public Point(double longitude, double latitude, double elevation) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.elevation = elevation;
    }
}

