/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import com.google.gson.annotations.SerializedName;
import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.json.geo.GeoJson;
import de.gerdiproject.json.geo.Point;
import de.gerdiproject.json.geo.Polygon;
import java.util.Arrays;
import java.util.List;

public class GeoLocation
implements ICleanable {
    @SerializedName(value="geoLocationPlace")
    private String place;
    @SerializedName(value="geoLocationPoint")
    private GeoJson point;
    @SerializedName(value="geoLocationBox")
    private GeoJson box;
    @SerializedName(value="geoLocationPolygon")
    private List<GeoJson> polygons;

    public GeoLocation(String place) {
        this.place = place;
    }

    public void setBox(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        List<Point> boxShape = Arrays.asList(new Point(westBoundLongitude, northBoundLatitude), new Point(eastBoundLongitude, northBoundLatitude), new Point(eastBoundLongitude, southBoundLatitude), new Point(westBoundLongitude, southBoundLatitude), new Point(westBoundLongitude, northBoundLatitude));
        this.box = new GeoJson(new Polygon(boxShape));
    }

    @Override
    public boolean clean() {
        this.cleanPoint();
        this.cleanPolygons();
        this.cleanBox();
        return this.isValid();
    }

    private void cleanPoint() {
        if (this.point == null) {
            return;
        }
        this.point.clean();
        if (!this.point.isValid()) {
            this.point = null;
        }
    }

    private void cleanPolygons() {
        if (this.polygons == null) {
            return;
        }
        int i = this.polygons.size();
        while (i != 0) {
            GeoJson geo;
            if ((geo = this.polygons.get(--i)) == null) {
                this.polygons.remove(i);
                continue;
            }
            geo.clean();
            if (geo.isValid()) continue;
            this.polygons.remove(i);
        }
        if (this.polygons.isEmpty()) {
            this.polygons = null;
        }
    }

    private void cleanBox() {
        if (this.box == null) {
            return;
        }
        this.box.clean();
        if (!this.box.isValid()) {
            this.box = null;
        }
    }

    public boolean isValid() {
        return this.place != null || this.box != null || this.polygons != null && !this.polygons.isEmpty() || this.point != null;
    }

    public String getPlace() {
        return this.place;
    }

    public GeoJson getPoint() {
        return this.point;
    }

    public GeoJson getBox() {
        return this.box;
    }

    public List<GeoJson> getPolygons() {
        return this.polygons;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public void setPoint(GeoJson point) {
        this.point = point;
    }

    public void setBox(GeoJson box) {
        this.box = box;
    }

    public void setPolygons(List<GeoJson> polygons) {
        this.polygons = polygons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        GeoJson this$point = this.getPoint();
        GeoJson other$point = other.getPoint();
        if (this$point == null ? other$point != null : !((Object)this$point).equals(other$point)) {
            return false;
        }
        GeoJson this$box = this.getBox();
        GeoJson other$box = other.getBox();
        if (this$box == null ? other$box != null : !((Object)this$box).equals(other$box)) {
            return false;
        }
        List<GeoJson> this$polygons = this.getPolygons();
        List<GeoJson> other$polygons = other.getPolygons();
        return !(this$polygons == null ? other$polygons != null : !((Object)this$polygons).equals(other$polygons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        GeoJson $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : ((Object)$point).hashCode());
        GeoJson $box = this.getBox();
        result = result * 59 + ($box == null ? 43 : ((Object)$box).hashCode());
        List<GeoJson> $polygons = this.getPolygons();
        result = result * 59 + ($polygons == null ? 43 : ((Object)$polygons).hashCode());
        return result;
    }

    public String toString() {
        return "GeoLocation(place=" + this.getPlace() + ", point=" + this.getPoint() + ", box=" + this.getBox() + ", polygons=" + this.getPolygons() + ")";
    }

    public GeoLocation() {
    }
}

