/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import com.google.gson.Gson;
import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.utils.CollectionUtils;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.AlternateIdentifier;
import de.gerdiproject.json.datacite.Contributor;
import de.gerdiproject.json.datacite.Creator;
import de.gerdiproject.json.datacite.Description;
import de.gerdiproject.json.datacite.FundingReference;
import de.gerdiproject.json.datacite.GeoLocation;
import de.gerdiproject.json.datacite.Identifier;
import de.gerdiproject.json.datacite.RelatedIdentifier;
import de.gerdiproject.json.datacite.ResourceType;
import de.gerdiproject.json.datacite.Rights;
import de.gerdiproject.json.datacite.Subject;
import de.gerdiproject.json.datacite.Title;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.extension.DataCiteExtensions;
import de.gerdiproject.json.datacite.extension.IDataCiteExtension;
import de.gerdiproject.json.datacite.extension.generic.AbstractResearch;
import de.gerdiproject.json.datacite.extension.generic.ResearchData;
import de.gerdiproject.json.datacite.extension.generic.WebLink;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class DataCiteJson
implements IDocument {
    private static final Gson GSON = GsonUtils.createGerdiDocumentGsonBuilder().create();
    @NonNull
    private final transient String sourceId;
    private Identifier identifier;
    private List<Creator> creators;
    private Set<Title> titles;
    private String publisher;
    private Integer publicationYear;
    private ResourceType resourceType;
    private Set<Subject> subjects;
    private Set<Contributor> contributors;
    private Set<AbstractDate> dates;
    private String language;
    private Set<AlternateIdentifier> alternateIdentifiers;
    private Set<RelatedIdentifier> relatedIdentifiers;
    private Set<String> sizes;
    private Set<String> formats;
    private String version;
    private Set<Rights> rightsList;
    private Set<Description> descriptions;
    private Set<GeoLocation> geoLocations;
    private Set<FundingReference> fundingReferences;
    private String repositoryIdentifier;
    private Set<WebLink> webLinks;
    private Set<ResearchData> researchDataList;
    private Set<AbstractResearch> researchDisciplines;
    private final DataCiteExtensions extensions;

    public DataCiteJson(String sourceId) throws IllegalArgumentException {
        this.sourceId = sourceId;
        this.extensions = new DataCiteExtensions();
    }

    public void addSizes(Collection<String> sizes) {
        this.sizes = CollectionUtils.addToSet(this.sizes, sizes);
    }

    public void addFormats(Collection<String> formats) {
        this.formats = CollectionUtils.addToSet(this.formats, formats);
    }

    public void addCreators(Collection<Creator> creators) {
        this.creators = CollectionUtils.addToList(this.creators, creators);
    }

    public void addTitles(Collection<Title> titles) {
        this.titles = CollectionUtils.addToSet(this.titles, titles);
    }

    public void addDescriptions(Collection<Description> descriptions) {
        this.descriptions = CollectionUtils.addToSet(this.descriptions, descriptions);
    }

    public void addSubjects(Collection<Subject> subjects) {
        this.subjects = CollectionUtils.addToSet(this.subjects, subjects);
    }

    public void addContributors(Collection<Contributor> contributors) {
        this.contributors = CollectionUtils.addToSet(this.contributors, contributors);
    }

    public void addDates(Collection<AbstractDate> dates) {
        this.dates = CollectionUtils.addToSet(this.dates, dates);
    }

    public void addGeoLocations(Collection<GeoLocation> geoLocations) {
        this.geoLocations = CollectionUtils.addToSet(this.geoLocations, geoLocations);
    }

    public void addRelatedIdentifiers(Collection<RelatedIdentifier> relatedIdentifiers) {
        this.relatedIdentifiers = CollectionUtils.addToSet(this.relatedIdentifiers, relatedIdentifiers);
    }

    public void addAlternateIdentifiers(Collection<AlternateIdentifier> alternateIdentifiers) {
        this.alternateIdentifiers = CollectionUtils.addToSet(this.alternateIdentifiers, alternateIdentifiers);
    }

    public void addRights(Collection<Rights> rightsList) {
        this.rightsList = CollectionUtils.addToSet(this.rightsList, rightsList);
    }

    public void addFundingReferences(Collection<FundingReference> fundingReferences) {
        this.fundingReferences = CollectionUtils.addToSet(this.fundingReferences, fundingReferences);
    }

    public void addWebLinks(Collection<WebLink> webLinks) {
        this.webLinks = CollectionUtils.addToSet(this.webLinks, webLinks);
    }

    public void addResearchData(Collection<ResearchData> researchDataList) {
        this.researchDataList = CollectionUtils.addToSet(this.researchDataList, researchDataList);
    }

    public void addResearchDisciplines(Collection<AbstractResearch> researchDisciplines) {
        this.researchDisciplines = CollectionUtils.addToSet(this.researchDisciplines, researchDisciplines);
    }

    public void setRepositoryIdentifier(String repositoryIdentifier) {
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public void addExtension(IDataCiteExtension extension) {
        this.extensions.add(extension);
    }

    @Override
    public String toJson() {
        return GSON.toJson((Object)this);
    }

    @Override
    @NonNull
    public String getSourceId() {
        return this.sourceId;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public List<Creator> getCreators() {
        return this.creators;
    }

    public Set<Title> getTitles() {
        return this.titles;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Integer getPublicationYear() {
        return this.publicationYear;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Set<Subject> getSubjects() {
        return this.subjects;
    }

    public Set<Contributor> getContributors() {
        return this.contributors;
    }

    public Set<AbstractDate> getDates() {
        return this.dates;
    }

    public String getLanguage() {
        return this.language;
    }

    public Set<AlternateIdentifier> getAlternateIdentifiers() {
        return this.alternateIdentifiers;
    }

    public Set<RelatedIdentifier> getRelatedIdentifiers() {
        return this.relatedIdentifiers;
    }

    public Set<String> getSizes() {
        return this.sizes;
    }

    public Set<String> getFormats() {
        return this.formats;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<Rights> getRightsList() {
        return this.rightsList;
    }

    public Set<Description> getDescriptions() {
        return this.descriptions;
    }

    public Set<GeoLocation> getGeoLocations() {
        return this.geoLocations;
    }

    public Set<FundingReference> getFundingReferences() {
        return this.fundingReferences;
    }

    public String getRepositoryIdentifier() {
        return this.repositoryIdentifier;
    }

    public Set<WebLink> getWebLinks() {
        return this.webLinks;
    }

    public Set<ResearchData> getResearchDataList() {
        return this.researchDataList;
    }

    public Set<AbstractResearch> getResearchDisciplines() {
        return this.researchDisciplines;
    }

    public DataCiteExtensions getExtensions() {
        return this.extensions;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setPublicationYear(Integer publicationYear) {
        this.publicationYear = publicationYear;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataCiteJson)) {
            return false;
        }
        DataCiteJson other = (DataCiteJson)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$identifier = this.getIdentifier();
        Identifier other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        List<Creator> this$creators = this.getCreators();
        List<Creator> other$creators = other.getCreators();
        if (this$creators == null ? other$creators != null : !((Object)this$creators).equals(other$creators)) {
            return false;
        }
        Set<Title> this$titles = this.getTitles();
        Set<Title> other$titles = other.getTitles();
        if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
            return false;
        }
        String this$publisher = this.getPublisher();
        String other$publisher = other.getPublisher();
        if (this$publisher == null ? other$publisher != null : !this$publisher.equals(other$publisher)) {
            return false;
        }
        Integer this$publicationYear = this.getPublicationYear();
        Integer other$publicationYear = other.getPublicationYear();
        if (this$publicationYear == null ? other$publicationYear != null : !((Object)this$publicationYear).equals(other$publicationYear)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)this$resourceType).equals(other$resourceType)) {
            return false;
        }
        Set<Subject> this$subjects = this.getSubjects();
        Set<Subject> other$subjects = other.getSubjects();
        if (this$subjects == null ? other$subjects != null : !((Object)this$subjects).equals(other$subjects)) {
            return false;
        }
        Set<Contributor> this$contributors = this.getContributors();
        Set<Contributor> other$contributors = other.getContributors();
        if (this$contributors == null ? other$contributors != null : !((Object)this$contributors).equals(other$contributors)) {
            return false;
        }
        Set<AbstractDate> this$dates = this.getDates();
        Set<AbstractDate> other$dates = other.getDates();
        if (this$dates == null ? other$dates != null : !((Object)this$dates).equals(other$dates)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        Set<AlternateIdentifier> this$alternateIdentifiers = this.getAlternateIdentifiers();
        Set<AlternateIdentifier> other$alternateIdentifiers = other.getAlternateIdentifiers();
        if (this$alternateIdentifiers == null ? other$alternateIdentifiers != null : !((Object)this$alternateIdentifiers).equals(other$alternateIdentifiers)) {
            return false;
        }
        Set<RelatedIdentifier> this$relatedIdentifiers = this.getRelatedIdentifiers();
        Set<RelatedIdentifier> other$relatedIdentifiers = other.getRelatedIdentifiers();
        if (this$relatedIdentifiers == null ? other$relatedIdentifiers != null : !((Object)this$relatedIdentifiers).equals(other$relatedIdentifiers)) {
            return false;
        }
        Set<String> this$sizes = this.getSizes();
        Set<String> other$sizes = other.getSizes();
        if (this$sizes == null ? other$sizes != null : !((Object)this$sizes).equals(other$sizes)) {
            return false;
        }
        Set<String> this$formats = this.getFormats();
        Set<String> other$formats = other.getFormats();
        if (this$formats == null ? other$formats != null : !((Object)this$formats).equals(other$formats)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Set<Rights> this$rightsList = this.getRightsList();
        Set<Rights> other$rightsList = other.getRightsList();
        if (this$rightsList == null ? other$rightsList != null : !((Object)this$rightsList).equals(other$rightsList)) {
            return false;
        }
        Set<Description> this$descriptions = this.getDescriptions();
        Set<Description> other$descriptions = other.getDescriptions();
        if (this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions)) {
            return false;
        }
        Set<GeoLocation> this$geoLocations = this.getGeoLocations();
        Set<GeoLocation> other$geoLocations = other.getGeoLocations();
        if (this$geoLocations == null ? other$geoLocations != null : !((Object)this$geoLocations).equals(other$geoLocations)) {
            return false;
        }
        Set<FundingReference> this$fundingReferences = this.getFundingReferences();
        Set<FundingReference> other$fundingReferences = other.getFundingReferences();
        if (this$fundingReferences == null ? other$fundingReferences != null : !((Object)this$fundingReferences).equals(other$fundingReferences)) {
            return false;
        }
        String this$repositoryIdentifier = this.getRepositoryIdentifier();
        String other$repositoryIdentifier = other.getRepositoryIdentifier();
        if (this$repositoryIdentifier == null ? other$repositoryIdentifier != null : !this$repositoryIdentifier.equals(other$repositoryIdentifier)) {
            return false;
        }
        Set<WebLink> this$webLinks = this.getWebLinks();
        Set<WebLink> other$webLinks = other.getWebLinks();
        if (this$webLinks == null ? other$webLinks != null : !((Object)this$webLinks).equals(other$webLinks)) {
            return false;
        }
        Set<ResearchData> this$researchDataList = this.getResearchDataList();
        Set<ResearchData> other$researchDataList = other.getResearchDataList();
        if (this$researchDataList == null ? other$researchDataList != null : !((Object)this$researchDataList).equals(other$researchDataList)) {
            return false;
        }
        Set<AbstractResearch> this$researchDisciplines = this.getResearchDisciplines();
        Set<AbstractResearch> other$researchDisciplines = other.getResearchDisciplines();
        if (this$researchDisciplines == null ? other$researchDisciplines != null : !((Object)this$researchDisciplines).equals(other$researchDisciplines)) {
            return false;
        }
        DataCiteExtensions this$extensions = this.getExtensions();
        DataCiteExtensions other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataCiteJson;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        List<Creator> $creators = this.getCreators();
        result = result * 59 + ($creators == null ? 43 : ((Object)$creators).hashCode());
        Set<Title> $titles = this.getTitles();
        result = result * 59 + ($titles == null ? 43 : ((Object)$titles).hashCode());
        String $publisher = this.getPublisher();
        result = result * 59 + ($publisher == null ? 43 : $publisher.hashCode());
        Integer $publicationYear = this.getPublicationYear();
        result = result * 59 + ($publicationYear == null ? 43 : ((Object)$publicationYear).hashCode());
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)$resourceType).hashCode());
        Set<Subject> $subjects = this.getSubjects();
        result = result * 59 + ($subjects == null ? 43 : ((Object)$subjects).hashCode());
        Set<Contributor> $contributors = this.getContributors();
        result = result * 59 + ($contributors == null ? 43 : ((Object)$contributors).hashCode());
        Set<AbstractDate> $dates = this.getDates();
        result = result * 59 + ($dates == null ? 43 : ((Object)$dates).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        Set<AlternateIdentifier> $alternateIdentifiers = this.getAlternateIdentifiers();
        result = result * 59 + ($alternateIdentifiers == null ? 43 : ((Object)$alternateIdentifiers).hashCode());
        Set<RelatedIdentifier> $relatedIdentifiers = this.getRelatedIdentifiers();
        result = result * 59 + ($relatedIdentifiers == null ? 43 : ((Object)$relatedIdentifiers).hashCode());
        Set<String> $sizes = this.getSizes();
        result = result * 59 + ($sizes == null ? 43 : ((Object)$sizes).hashCode());
        Set<String> $formats = this.getFormats();
        result = result * 59 + ($formats == null ? 43 : ((Object)$formats).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Set<Rights> $rightsList = this.getRightsList();
        result = result * 59 + ($rightsList == null ? 43 : ((Object)$rightsList).hashCode());
        Set<Description> $descriptions = this.getDescriptions();
        result = result * 59 + ($descriptions == null ? 43 : ((Object)$descriptions).hashCode());
        Set<GeoLocation> $geoLocations = this.getGeoLocations();
        result = result * 59 + ($geoLocations == null ? 43 : ((Object)$geoLocations).hashCode());
        Set<FundingReference> $fundingReferences = this.getFundingReferences();
        result = result * 59 + ($fundingReferences == null ? 43 : ((Object)$fundingReferences).hashCode());
        String $repositoryIdentifier = this.getRepositoryIdentifier();
        result = result * 59 + ($repositoryIdentifier == null ? 43 : $repositoryIdentifier.hashCode());
        Set<WebLink> $webLinks = this.getWebLinks();
        result = result * 59 + ($webLinks == null ? 43 : ((Object)$webLinks).hashCode());
        Set<ResearchData> $researchDataList = this.getResearchDataList();
        result = result * 59 + ($researchDataList == null ? 43 : ((Object)$researchDataList).hashCode());
        Set<AbstractResearch> $researchDisciplines = this.getResearchDisciplines();
        result = result * 59 + ($researchDisciplines == null ? 43 : ((Object)$researchDisciplines).hashCode());
        DataCiteExtensions $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    public String toString() {
        return "DataCiteJson(sourceId=" + this.getSourceId() + ", identifier=" + this.getIdentifier() + ", creators=" + this.getCreators() + ", titles=" + this.getTitles() + ", publisher=" + this.getPublisher() + ", publicationYear=" + this.getPublicationYear() + ", resourceType=" + this.getResourceType() + ", subjects=" + this.getSubjects() + ", contributors=" + this.getContributors() + ", dates=" + this.getDates() + ", language=" + this.getLanguage() + ", alternateIdentifiers=" + this.getAlternateIdentifiers() + ", relatedIdentifiers=" + this.getRelatedIdentifiers() + ", sizes=" + this.getSizes() + ", formats=" + this.getFormats() + ", version=" + this.getVersion() + ", rightsList=" + this.getRightsList() + ", descriptions=" + this.getDescriptions() + ", geoLocations=" + this.getGeoLocations() + ", fundingReferences=" + this.getFundingReferences() + ", repositoryIdentifier=" + this.getRepositoryIdentifier() + ", webLinks=" + this.getWebLinks() + ", researchDataList=" + this.getResearchDataList() + ", researchDisciplines=" + this.getResearchDisciplines() + ", extensions=" + this.getExtensions() + ")";
    }
}

