/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json;

import de.gerdiproject.harvest.utils.StringUtils;
import de.gerdiproject.json.datacite.Date;
import de.gerdiproject.json.datacite.DateRange;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import de.gerdiproject.json.datacite.enums.DateType;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Iterator;
import java.util.regex.Matcher;

public class DateUtils {
    public static Instant unixTimestampToInstant(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }

    public static Instant[] parseDateRange(String dateString) {
        String separator;
        Instant[] dates = null;
        Iterator<String> iterator = DataCiteDateConstants.DATE_RANGE_SEPARATORS.iterator();
        while (iterator.hasNext() && (dates = DateUtils.parseDateRange(dateString, separator = iterator.next())) == null) {
        }
        return dates;
    }

    public static Instant[] parseDateRange(String dateString, String separator) {
        Instant[] dates = new Instant[2];
        if (dateString.contains(separator)) {
            String[] dateRangeElements = dateString.split(separator);
            if (dateRangeElements.length == 2) {
                dates[0] = DateUtils.parseDate(dateRangeElements[0]);
                dates[1] = DateUtils.parseDate(dateRangeElements[1]);
            } else if (dateRangeElements.length > 2 && dateRangeElements.length % 2 == 0) {
                int separatorLength = separator.length();
                int halfLength = 0;
                int len = dateRangeElements.length / 2;
                for (int i = 0; i < len; ++i) {
                    halfLength += dateRangeElements[i].length() + separatorLength;
                }
                dates[0] = DateUtils.parseDate(dateString.substring(0, halfLength));
                dates[1] = DateUtils.parseDate(dateString.substring(halfLength));
            }
        }
        return dates[0] == null && dates[1] == null ? null : dates;
    }

    public static Instant parseDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        String cleanString = StringUtils.clean(dateString);
        if (cleanString.isEmpty()) {
            return null;
        }
        Instant parsedDate = null;
        if (DateUtils.isPotentialIso8601String(cleanString)) {
            parsedDate = DateUtils.parseIso8601String(cleanString);
        }
        if (parsedDate == null) {
            parsedDate = DateUtils.parseNonStandardDateString(cleanString);
        }
        return parsedDate;
    }

    public static AbstractDate parseAbstractDate(String dateString, DateType type) {
        AbstractDate date = new DateRange(dateString, type);
        boolean isValidDate = date.clean();
        if (!isValidDate) {
            date = new Date(dateString, type);
            isValidDate = date.clean();
        }
        return isValidDate ? date : null;
    }

    private static boolean isPotentialIso8601String(String dateString) {
        int stringLength = dateString.length();
        char firstChar = dateString.charAt(0);
        char lastChar = dateString.charAt(stringLength - 1);
        return stringLength > 10 && Character.isDigit(firstChar) && (lastChar == 'Z' || Character.isDigit(lastChar));
    }

    private static Instant parseIso8601String(String dateString) {
        Instant parsedValue;
        try {
            parsedValue = Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(dateString));
        }
        catch (DateTimeException e1) {
            try {
                parsedValue = Instant.from(DataCiteDateConstants.ISO8601_FORMATTER.parse(dateString));
            }
            catch (DateTimeException e2) {
                parsedValue = null;
            }
        }
        return parsedValue;
    }

    private static Instant parseNonStandardDateString(String dateString) {
        String[] dateSegments = dateString.split("[\\-/,;. \\\\]+");
        int day = 1;
        int month = 1;
        int year = 0;
        boolean hasDay = false;
        boolean hasMonth = false;
        boolean hasYear = false;
        for (String s : dateSegments) {
            if (s.isEmpty()) continue;
            if (Character.isDigit(s.charAt(0))) {
                int num = DateUtils.parseNumberSegment(s);
                if (num == 0 || num > 9999) continue;
                if (num > 31) {
                    year = num;
                    hasYear = true;
                    continue;
                }
                if (num > 12 || hasMonth || !hasYear && !hasDay) {
                    if (hasDay) {
                        month = day;
                        hasMonth = true;
                    }
                    day = num;
                    hasDay = true;
                    continue;
                }
                month = num;
                hasMonth = true;
                continue;
            }
            try {
                month = DataCiteDateConstants.MONTH_FORMATTER.parse(s).get(ChronoField.MONTH_OF_YEAR);
                hasMonth = true;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        if (!hasYear) {
            return null;
        }
        if (hasDay && !hasMonth) {
            month = day;
            day = 1;
        }
        if (month > 12) {
            month = 1;
            day = 1;
        }
        ZonedDateTime zdt = ZonedDateTime.of(year, month, day, 0, 0, 0, 0, DataCiteDateConstants.Z_ZONE_ID);
        return zdt.toInstant();
    }

    private static int parseNumberSegment(String dateSegment) {
        int parsedNumber = 0;
        int segmentLength = dateSegment.length();
        try {
            if (segmentLength > 4 || !Character.isDigit(dateSegment.charAt(segmentLength - 1))) {
                Matcher matcher = DataCiteDateConstants.NUMBERS_PATTERN.matcher(dateSegment);
                if (matcher.find()) {
                    parsedNumber = Integer.parseInt(matcher.group(1));
                }
            } else {
                parsedNumber = Integer.parseInt(dateSegment);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parsedNumber;
    }

    private DateUtils() {
    }
}

