/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import de.gerdiproject.harvest.ICleanable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionUtils.class);

    public static <T> Set<T> addToSet(Set<T> set, Collection<T> addedElements) {
        if (addedElements == null || addedElements.isEmpty()) {
            return set;
        }
        HashSet<T> tempSet = set == null ? new HashSet<T>() : set;
        boolean isLogging = LOGGER.isDebugEnabled();
        for (T element : addedElements) {
            if (!CollectionUtils.validateAndLogElement(element, isLogging)) continue;
            tempSet.add(element);
        }
        return tempSet.isEmpty() ? null : tempSet;
    }

    public static <T> List<T> addToList(List<T> list, Collection<T> addedElements) {
        if (addedElements == null || addedElements.isEmpty()) {
            return list;
        }
        LinkedList<T> tempList = list == null ? new LinkedList<T>() : list;
        boolean isLogging = LOGGER.isDebugEnabled();
        for (T element : addedElements) {
            if (!CollectionUtils.validateAndLogElement(element, isLogging)) continue;
            if (tempList.contains(element)) {
                if (!isLogging) continue;
                LOGGER.debug(String.format("Discarded %s, because it is a duplicate:%n%s", element.getClass().getSimpleName(), element.toString()));
                continue;
            }
            tempList.add(element);
        }
        return tempList.isEmpty() ? null : tempList;
    }

    public static <T> Map<String, T> addToMap(Map<String, T> map, String key, T value) {
        HashMap<String, T> tempMap;
        if (value == null) {
            return map;
        }
        HashMap<String, T> hashMap = tempMap = map == null ? new HashMap<String, T>() : map;
        if (CollectionUtils.validateAndLogElement(value, LOGGER.isDebugEnabled())) {
            tempMap.put(key, value);
        }
        return tempMap.isEmpty() ? null : tempMap;
    }

    private static <T> boolean validateAndLogElement(T element, boolean isLogging) {
        boolean isValidElement;
        if (element == null) {
            isValidElement = false;
        } else if (element instanceof ICleanable) {
            ICleanable cleanableElement = (ICleanable)element;
            if (isLogging) {
                String preCleanedString = cleanableElement.toString();
                isValidElement = cleanableElement.clean();
                if (!isValidElement) {
                    LOGGER.debug(String.format("Discarded %s, because it was deemed invalid:%n%s", cleanableElement.getClass().getSimpleName(), preCleanedString));
                }
            } else {
                isValidElement = cleanableElement.clean();
            }
        } else {
            isValidElement = true;
        }
        return isValidElement;
    }

    private CollectionUtils() {
    }
}

