/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import de.gerdiproject.json.geo.IGeoCoordinates;
import de.gerdiproject.json.geo.Point;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Polygon
extends LinkedList<List<Point>>
implements IGeoCoordinates {
    private static final long serialVersionUID = -9154174270949179550L;

    public Polygon(List<Point> filledShape) {
        this.add(filledShape);
    }

    public Polygon(List<Point> filledShape, Collection<List<Point>> holes) {
        this.add(filledShape);
        this.addAll(holes);
    }

    public Polygon(Collection<List<Point>> shapes) {
        super(shapes);
    }

    public Polygon(JsonArray array) {
        array.forEach(ele -> {
            JsonArray ring = ele.getAsJsonArray();
            LinkedList<Point> shape = new LinkedList<Point>();
            for (JsonElement point : ring) {
                shape.add(new Point(point.getAsJsonArray()));
            }
            this.add(shape);
        });
    }

    public boolean hasHoles() {
        return this.size() > 1;
    }

    public List<Point> getFilledShape() {
        return (List)this.get(0);
    }

    public void setFilledShape(List<Point> shape) {
        this.set(0, shape);
    }

    public List<List<Point>> getHoles() {
        return super.subList(1, this.size());
    }

    public void removeAllHoles() {
        super.removeAll(this.getHoles());
    }
}

