/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.geo.IGeoCoordinates;
import de.gerdiproject.json.geo.MultiPolygon;
import de.gerdiproject.json.geo.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJson
implements ICleanable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoJson.class);
    private static final Gson GSON = GsonUtils.createGeoJsonGsonBuilder().create();
    private IGeoCoordinates coordinates;
    private transient boolean isClean;
    private String type;

    public GeoJson(IGeoCoordinates coordinates) {
        this.setCoordinates(coordinates);
    }

    public void setCoordinates(IGeoCoordinates coordinates) {
        this.type = coordinates == null ? "Invalid" : coordinates.getClass().getSimpleName();
        this.coordinates = coordinates;
        this.isClean = false;
    }

    public boolean isValid() {
        return this.coordinates != null;
    }

    @Override
    public boolean clean() {
        if (!this.isClean && this.coordinates != null && (this.coordinates instanceof Polygon || this.coordinates instanceof MultiPolygon)) {
            String geoJsonString = GSON.toJson((Object)this);
            try {
                OGCGeometry polygon = OGCGeometry.fromGeoJson((String)geoJsonString);
                String simpleGeoString = polygon.makeSimple().asGeoJson();
                GeoJson cleanedGeo = (GeoJson)GSON.fromJson(simpleGeoString, GeoJson.class);
                this.setCoordinates(cleanedGeo.coordinates);
                this.isClean = true;
            }
            catch (JsonSyntaxException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Invalid GeoJson:%n%s", geoJsonString));
                }
                this.setCoordinates(null);
            }
        }
        return this.isValid();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoJson)) {
            return false;
        }
        GeoJson other = (GeoJson)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IGeoCoordinates this$coordinates = this.getCoordinates();
        IGeoCoordinates other$coordinates = other.getCoordinates();
        if (this$coordinates == null ? other$coordinates != null : !this$coordinates.equals(other$coordinates)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoJson;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IGeoCoordinates $coordinates = this.getCoordinates();
        result = result * 59 + ($coordinates == null ? 43 : $coordinates.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public IGeoCoordinates getCoordinates() {
        return this.coordinates;
    }

    public String getType() {
        return this.type;
    }
}

