/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.gerdiproject.json.datacite.Date;
import de.gerdiproject.json.datacite.DateRange;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.enums.DateType;
import java.lang.reflect.Type;

public class DateAdapter
implements JsonDeserializer<AbstractDate>,
JsonSerializer<AbstractDate> {
    public AbstractDate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject dateJsonObj = json.getAsJsonObject();
        DateType dateType = DateType.valueOf(dateJsonObj.get("dateType").getAsString());
        String value = dateJsonObj.get("value").getAsString();
        AbstractDate returnDate = value.indexOf("/") != -1 ? new DateRange(value, dateType) : new Date(value, dateType);
        JsonElement rawDateInfo = dateJsonObj.get("dateInformation");
        if (rawDateInfo != null) {
            returnDate.setDateInformation(rawDateInfo.getAsString());
        }
        return returnDate;
    }

    public JsonElement serialize(AbstractDate src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject dateJson = new JsonObject();
        dateJson.addProperty("value", src.getValue());
        dateJson.addProperty("dateType", src.getType().toString());
        String dateInfo = src.getDateInformation();
        if (dateInfo != null) {
            dateJson.addProperty("dateInformation", dateInfo);
        }
        return dateJson;
    }
}

