/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.gerdiproject.json.datacite.extension.DataCiteExtensions;
import de.gerdiproject.json.datacite.extension.IDataCiteExtension;
import de.gerdiproject.json.datacite.extension.soep.SoepDataCiteExtension;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCiteExtensionsAdapter
implements JsonDeserializer<DataCiteExtensions>,
JsonSerializer<DataCiteExtensions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCiteExtensionsAdapter.class);

    public DataCiteExtensions deserialize(JsonElement src, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject sourceObject = src.getAsJsonObject();
        Set keys = sourceObject.keySet();
        DataCiteExtensions deserializedObject = new DataCiteExtensions();
        for (String key : keys) {
            IDataCiteExtension ex = this.jsonToExtension(key, sourceObject.get(key), context);
            deserializedObject.add(ex);
        }
        return deserializedObject.getExtensions() == null ? null : deserializedObject;
    }

    public JsonElement serialize(DataCiteExtensions src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null || src.getExtensions() == null || src.getExtensions().isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject serializedObject = new JsonObject();
        for (Map.Entry<String, IDataCiteExtension> extension : src.getExtensions().entrySet()) {
            JsonElement exJson = context.serialize((Object)extension.getValue());
            if (exJson.isJsonNull()) continue;
            serializedObject.add(extension.getKey(), exJson);
        }
        return serializedObject.size() == 0 ? JsonNull.INSTANCE : serializedObject;
    }

    private IDataCiteExtension jsonToExtension(String key, JsonElement json, JsonDeserializationContext context) {
        IDataCiteExtension extension;
        switch (key) {
            case "soep": {
                extension = (IDataCiteExtension)context.deserialize(json, SoepDataCiteExtension.class);
                break;
            }
            default: {
                LOGGER.error("Unknown GeRDI extension: " + key);
                extension = null;
            }
        }
        return extension;
    }
}

