/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.abstr;

import com.google.gson.annotations.SerializedName;
import de.gerdiproject.harvest.utils.StringCleaner;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import de.gerdiproject.json.datacite.enums.DateType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDate {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDate.class);
    @SerializedName(value="dateType")
    private final DateType type;
    private String dateInformation;

    public abstract String getValue();

    public abstract void setValue(String var1);

    protected static Instant stringToInstant(String stringValue) {
        if (stringValue == null || stringValue.isEmpty()) {
            return null;
        }
        String cleanString = StringCleaner.clean(stringValue.replaceAll("(T\\d\\d:\\d\\d)([Z+])", "$1:00$2"));
        if (!Character.isDigit(cleanString.charAt(0))) {
            cleanString = cleanString.replaceAll("^\\D+\\s([^0-9]+[,.-]?\\s?\\d[\\d\\D]+)$", "$1");
            for (SimpleDateFormat format : DataCiteDateConstants.DATE_FORMATS_STARTING_WITH_CHAR) {
                try {
                    return format.parse(cleanString).toInstant();
                }
                catch (ParseException parseException) {
                }
            }
            cleanString = cleanString.replaceAll("^\\D+(\\d[\\d\\D]+)$", "$1");
        }
        if (Character.isDigit(cleanString.charAt(0))) {
            try {
                Calendar parsedCalendar = DatatypeConverter.parseDateTime((String)cleanString);
                parsedCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                return parsedCalendar.toInstant();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (SimpleDateFormat format : DataCiteDateConstants.DATE_FORMATS_STARTING_WITH_NUM) {
                    try {
                        return format.parse(cleanString).toInstant();
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
        }
        LOGGER.warn(String.format("Could not parse date string '%s'!", stringValue));
        return null;
    }

    protected static Instant unixTimestampToInstant(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }

    public AbstractDate(DateType type) {
        this.type = type;
    }

    public DateType getType() {
        return this.type;
    }

    public String getDateInformation() {
        return this.dateInformation;
    }

    public void setDateInformation(String dateInformation) {
        this.dateInformation = dateInformation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDate)) {
            return false;
        }
        AbstractDate other = (AbstractDate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateType this$type = this.getType();
        DateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$dateInformation = this.getDateInformation();
        String other$dateInformation = other.getDateInformation();
        return !(this$dateInformation == null ? other$dateInformation != null : !this$dateInformation.equals(other$dateInformation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $dateInformation = this.getDateInformation();
        result = result * 59 + ($dateInformation == null ? 43 : $dateInformation.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractDate(type=" + (Object)((Object)this.getType()) + ", dateInformation=" + this.getDateInformation() + ")";
    }
}

