/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.harvest.utils.StringCleaner;
import lombok.NonNull;

public class Subject
implements ICleanable {
    @NonNull
    private String value;
    private String lang;
    private String subjectScheme;
    private String schemeURI;
    private String valueURI;

    public Subject(String value, String lang) {
        this(value);
        this.lang = lang;
    }

    @Override
    public boolean clean() {
        this.setValue(StringCleaner.clean(this.value));
        return true;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSubjectScheme() {
        return this.subjectScheme;
    }

    public String getSchemeURI() {
        return this.schemeURI;
    }

    public String getValueURI() {
        return this.valueURI;
    }

    public void setValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setSubjectScheme(String subjectScheme) {
        this.subjectScheme = subjectScheme;
    }

    public void setSchemeURI(String schemeURI) {
        this.schemeURI = schemeURI;
    }

    public void setValueURI(String valueURI) {
        this.valueURI = valueURI;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subject)) {
            return false;
        }
        Subject other = (Subject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$subjectScheme = this.getSubjectScheme();
        String other$subjectScheme = other.getSubjectScheme();
        if (this$subjectScheme == null ? other$subjectScheme != null : !this$subjectScheme.equals(other$subjectScheme)) {
            return false;
        }
        String this$schemeURI = this.getSchemeURI();
        String other$schemeURI = other.getSchemeURI();
        if (this$schemeURI == null ? other$schemeURI != null : !this$schemeURI.equals(other$schemeURI)) {
            return false;
        }
        String this$valueURI = this.getValueURI();
        String other$valueURI = other.getValueURI();
        return !(this$valueURI == null ? other$valueURI != null : !this$valueURI.equals(other$valueURI));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Subject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $subjectScheme = this.getSubjectScheme();
        result = result * 59 + ($subjectScheme == null ? 43 : $subjectScheme.hashCode());
        String $schemeURI = this.getSchemeURI();
        result = result * 59 + ($schemeURI == null ? 43 : $schemeURI.hashCode());
        String $valueURI = this.getValueURI();
        result = result * 59 + ($valueURI == null ? 43 : $valueURI.hashCode());
        return result;
    }

    public String toString() {
        return "Subject(value=" + this.getValue() + ", lang=" + this.getLang() + ", subjectScheme=" + this.getSubjectScheme() + ", schemeURI=" + this.getSchemeURI() + ", valueURI=" + this.getValueURI() + ")";
    }

    public Subject(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value;
    }

    public Subject(@NonNull String value, String lang, String subjectScheme, String schemeURI, String valueURI) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value;
        this.lang = lang;
        this.subjectScheme = subjectScheme;
        this.schemeURI = schemeURI;
        this.valueURI = valueURI;
    }
}

