/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import de.gerdiproject.json.datacite.enums.DateType;
import java.time.Instant;
import java.time.ZonedDateTime;

public class DateRange
extends AbstractDate {
    private Instant since;
    private Instant until;

    public DateRange(String dateString, DateType type) {
        super(type);
        this.setValue(dateString);
    }

    public DateRange(long epochMilliSince, long epochMilliUntil, DateType type) {
        super(type);
        this.setRangeFrom(epochMilliSince);
        this.setRangeUntil(epochMilliUntil);
    }

    public DateRange(String rangeFrom, String rangeUntil, DateType type) {
        super(type);
        this.setRangeFrom(rangeFrom);
        this.setRangeUntil(rangeUntil);
    }

    @Override
    public String getValue() {
        String sinceVal = "";
        String untilVal = "";
        if (this.since != null) {
            sinceVal = this.since.toString();
        }
        if (this.until != null) {
            untilVal = this.until.toString();
        }
        return sinceVal + "/" + untilVal;
    }

    @Override
    public void setValue(String stringValue) {
        String[] range = stringValue.split("/");
        if (range.length == 2) {
            this.setRangeFrom(range[0]);
            this.setRangeUntil(range[1]);
        } else if (range.length == 1) {
            this.setRangeFrom(range[0]);
        } else {
            LOGGER.error(String.format("Could not parse date string '%s'!", stringValue));
        }
    }

    public ZonedDateTime getRangeFromAsDateTime() {
        return this.since == null ? null : ZonedDateTime.ofInstant(this.since, DataCiteDateConstants.Z_ZONE_ID);
    }

    public void setRangeFrom(long epochMilli) {
        this.since = DateRange.unixTimestampToInstant(epochMilli);
    }

    public void setRangeFrom(String stringValue) {
        this.since = DateRange.stringToInstant(stringValue);
    }

    public ZonedDateTime getRangeUntilAsDateTime() {
        return this.until == null ? null : ZonedDateTime.ofInstant(this.until, DataCiteDateConstants.Z_ZONE_ID);
    }

    public void setRangeUntil(long epochMilli) {
        this.until = DateRange.unixTimestampToInstant(epochMilli);
    }

    public void setRangeUntil(String stringValue) {
        this.until = DateRange.stringToInstant(stringValue);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Instant this$since = this.since;
        Instant other$since = other.since;
        if (this$since == null ? other$since != null : !((Object)this$since).equals(other$since)) {
            return false;
        }
        Instant this$until = this.until;
        Instant other$until = other.until;
        return !(this$until == null ? other$until != null : !((Object)this$until).equals(other$until));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DateRange;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Instant $since = this.since;
        result = result * 59 + ($since == null ? 43 : ((Object)$since).hashCode());
        Instant $until = this.until;
        result = result * 59 + ($until == null ? 43 : ((Object)$until).hashCode());
        return result;
    }
}

