/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import de.gerdiproject.json.datacite.enums.DateType;
import java.time.Instant;
import java.time.ZonedDateTime;

public class Date
extends AbstractDate
implements ICleanable {
    private Instant value;

    public Date(String dateString, DateType type) {
        super(type);
        this.setValue(dateString);
    }

    public Date(long epochMilli, DateType type) {
        super(type);
        this.setDate(epochMilli);
    }

    @Override
    public String getValue() {
        return this.value != null ? this.value.toString() : null;
    }

    public ZonedDateTime getValueAsDateTime() {
        return this.value == null ? null : ZonedDateTime.ofInstant(this.value, DataCiteDateConstants.Z_ZONE_ID);
    }

    @Override
    public void setValue(String stringValue) {
        this.value = Date.stringToInstant(stringValue);
    }

    public void setDate(long epochMilli) {
        this.value = Date.unixTimestampToInstant(epochMilli);
    }

    public void setDate(Instant date) {
        this.value = date;
    }

    @Override
    public boolean clean() {
        return this.getValue() != null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Date)) {
            return false;
        }
        Date other = (Date)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Date;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

