/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import de.gerdiproject.harvest.ICleanable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    public static <T> Set<T> addToSet(Set<T> set, Collection<T> addedElements) {
        if (addedElements == null || addedElements.isEmpty()) {
            return set;
        }
        HashSet<T> tempSet = set == null ? new HashSet<T>() : set;
        for (T element : addedElements) {
            if (element == null) continue;
            if (element instanceof ICleanable) {
                ICleanable cleanableElement = (ICleanable)element;
                if (!cleanableElement.clean()) continue;
                tempSet.add(element);
                continue;
            }
            tempSet.add(element);
        }
        return tempSet.isEmpty() ? null : tempSet;
    }

    public static <T> List<T> addToList(List<T> list, Collection<T> addedElements) {
        if (addedElements == null || addedElements.isEmpty()) {
            return list;
        }
        LinkedList<T> tempList = list == null ? new LinkedList<T>() : list;
        for (T element : addedElements) {
            if (element == null || tempList.contains(element) || element instanceof ICleanable && !((ICleanable)element).clean()) continue;
            tempList.add(element);
        }
        return tempList.isEmpty() ? null : tempList;
    }

    public static <T> Map<String, T> addToMap(Map<String, T> map, String key, T value) {
        HashMap<String, T> tempMap;
        if (value == null) {
            return map;
        }
        HashMap<String, T> hashMap = tempMap = map == null ? new HashMap<String, T>() : map;
        if (!(value instanceof ICleanable) || ((ICleanable)value).clean()) {
            tempMap.put(key, value);
        }
        return tempMap.isEmpty() ? null : tempMap;
    }

    private CollectionUtils() {
    }
}

