/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.gerdiproject.json.geo.GeoJson;
import de.gerdiproject.json.geo.IGeoCoordinates;
import de.gerdiproject.json.geo.LineString;
import de.gerdiproject.json.geo.MultiLineString;
import de.gerdiproject.json.geo.MultiPoint;
import de.gerdiproject.json.geo.MultiPolygon;
import de.gerdiproject.json.geo.Point;
import de.gerdiproject.json.geo.Polygon;
import java.lang.reflect.Type;

public class GeoJsonAdapter
implements JsonDeserializer<GeoJson> {
    public GeoJson deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Point coordinates;
        JsonObject geoJsonRaw = json.getAsJsonObject();
        String type = geoJsonRaw.get("type").getAsString().toLowerCase();
        JsonArray coordinatesRaw = geoJsonRaw.get("coordinates").getAsJsonArray();
        switch (type) {
            case "point": {
                coordinates = new Point(coordinatesRaw);
                break;
            }
            case "multipoint": {
                coordinates = new MultiPoint(coordinatesRaw);
                break;
            }
            case "linestring": {
                coordinates = new LineString(coordinatesRaw);
                break;
            }
            case "multilinestring": {
                coordinates = new MultiLineString(coordinatesRaw);
                break;
            }
            case "polygon": {
                coordinates = new Polygon(coordinatesRaw);
                break;
            }
            case "multipolygon": {
                coordinates = new MultiPolygon(coordinatesRaw);
                break;
            }
            default: {
                throw new JsonParseException(String.format("Unknown GeoJson type '%s'!", type));
            }
        }
        return new GeoJson((IGeoCoordinates)coordinates);
    }
}

