/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.geo;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.geo.IGeoCoordinates;
import de.gerdiproject.json.geo.MultiPolygon;
import de.gerdiproject.json.geo.Polygon;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJson
implements ICleanable {
    private static final String PARSE_FAILED = "Could not simplify GeoJson:\n";
    private static final String INVALID_GEO = "Invalid GeoJson:\n";
    private static final String INVALID_TYPE = "Invalid";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoJson.class);
    private transient boolean isClean;
    private String type;
    private IGeoCoordinates coordinates;

    public GeoJson(IGeoCoordinates coordinates) {
        this.setCoordinates(coordinates);
    }

    public void setCoordinates(IGeoCoordinates coordinates) {
        this.type = coordinates == null ? INVALID_TYPE : coordinates.getClass().getSimpleName();
        this.coordinates = coordinates;
        this.isClean = false;
    }

    public boolean isValid() {
        return this.coordinates != null;
    }

    public String getType() {
        return this.type;
    }

    public IGeoCoordinates getCoordinates() {
        return this.coordinates;
    }

    public void clean() {
        if (!this.isClean && this.coordinates != null && (this.coordinates instanceof Polygon || this.coordinates instanceof MultiPolygon)) {
            Gson gson = GsonUtils.getGson();
            String geoJsonString = gson.toJson((Object)this);
            try {
                OGCGeometry polygon = OGCGeometry.fromGeoJson((String)geoJsonString);
                String simpleGeoString = polygon.makeSimple().asGeoJson();
                GeoJson cleanedGeo = (GeoJson)gson.fromJson(simpleGeoString, GeoJson.class);
                this.coordinates = cleanedGeo.coordinates;
                this.type = cleanedGeo.type;
                this.isClean = true;
            }
            catch (JSONException e) {
                LOGGER.warn(PARSE_FAILED + geoJsonString);
                this.setCoordinates(null);
            }
            catch (JsonSyntaxException e) {
                LOGGER.warn(INVALID_GEO + geoJsonString);
                this.setCoordinates(null);
            }
        }
    }
}

