/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.extension.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.gerdiproject.json.datacite.extension.abstr.AbstractResearch;
import de.gerdiproject.json.datacite.extension.constants.ResearchAreaConstants;
import de.gerdiproject.json.datacite.extension.constants.ResearchDisciplineConstants;
import java.lang.reflect.Type;

public class ResearchAdapter
implements JsonDeserializer<AbstractResearch>,
JsonSerializer<AbstractResearch> {
    public AbstractResearch deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String rnbrString = json.getAsJsonObject().get("rnbr").getAsString();
        Object output = rnbrString.indexOf(45) == -1 ? ResearchAreaConstants.getByRnbrString((String)rnbrString) : ResearchDisciplineConstants.getByRnbrString((String)rnbrString);
        return output;
    }

    public JsonElement serialize(AbstractResearch src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject rdObject = new JsonObject();
        rdObject.addProperty("area", src.getAreaName());
        rdObject.addProperty("category", src.getCategoryName());
        rdObject.addProperty("rnbr", src.getRnbrAsString());
        String disciString = src.getDisciplineName();
        if (disciString != null) {
            rdObject.addProperty("discipline", disciString);
        }
        return rdObject;
    }
}

